/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.tika.detect.ContainerDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.POIFSContainerDetector;
import org.apache.tika.detect.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ContainerAwareDetector
implements Detector {
    private Detector fallbackDetector;
    private ZipContainerDetector zipDetector;
    private POIFSContainerDetector poifsDetector;

    public ContainerAwareDetector(Detector fallbackDetector) {
        this.fallbackDetector = fallbackDetector;
        this.poifsDetector = new POIFSContainerDetector();
        this.zipDetector = new ZipContainerDetector();
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        return this.detect(TikaInputStream.get((InputStream)input), metadata);
    }

    public MediaType detect(TikaInputStream input, Metadata metadata) throws IOException {
        long ole2Signature;
        input.mark(8);
        byte[] first8 = new byte[8];
        IOUtils.readFully((InputStream)input, (byte[])first8);
        input.reset();
        if (first8[0] == POIFSConstants.OOXML_FILE_HEADER[0] && first8[1] == POIFSConstants.OOXML_FILE_HEADER[1] && first8[2] == POIFSConstants.OOXML_FILE_HEADER[2] && first8[3] == POIFSConstants.OOXML_FILE_HEADER[3]) {
            try {
                return this.detect(input, metadata, this.zipDetector);
            }
            catch (ZipException e) {
                input = TikaInputStream.get((File)input.getFile());
            }
        }
        if ((ole2Signature = LittleEndian.getLong((byte[])first8, (int)0)) == -2226271756974174256L) {
            try {
                return this.detect(input, metadata, this.poifsDetector);
            }
            catch (IOException e) {
                input = TikaInputStream.get((File)input.getFile());
            }
        }
        return this.fallbackDetector.detect((InputStream)input, metadata);
    }

    private MediaType detect(TikaInputStream input, Metadata metadata, ContainerDetector detector) throws IOException {
        MediaType defaultType;
        MediaType detected = detector.detect(input, metadata);
        if (!detected.equals((Object)(defaultType = detector.getDefault()))) {
            return detected;
        }
        detected = this.fallbackDetector.detect((InputStream)input, metadata);
        if (!detected.equals((Object)MediaType.OCTET_STREAM)) {
            return detected;
        }
        return defaultType;
    }
}

