/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.ExcelExtractor;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.parser.microsoft.SummaryExtractor;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeParser
implements Parser {
    private static final long serialVersionUID = 7393462244028653479L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(POIFSDocumentType.access$000(POIFSDocumentType.WORKBOOK), POIFSDocumentType.access$000(POIFSDocumentType.OLE10_NATIVE), POIFSDocumentType.access$000(POIFSDocumentType.WORDDOCUMENT), POIFSDocumentType.access$000(POIFSDocumentType.UNKNOWN), POIFSDocumentType.access$000(POIFSDocumentType.ENCRYPTED), POIFSDocumentType.access$000(POIFSDocumentType.POWERPOINT), POIFSDocumentType.access$000(POIFSDocumentType.PUBLISHER), POIFSDocumentType.access$000(POIFSDocumentType.VISIO), POIFSDocumentType.access$000(POIFSDocumentType.OUTLOOK), MediaType.application((String)"vnd.ms-excel.sheet.binary.macroenabled.12"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        POIFSFileSystem filesystem = stream instanceof TikaInputStream && ((TikaInputStream)stream).getOpenContainer() != null ? (POIFSFileSystem)((TikaInputStream)stream).getOpenContainer() : new POIFSFileSystem(stream);
        new SummaryExtractor(metadata).parseSummaries(filesystem);
        boolean outlookExtracted = false;
        block11: for (Entry entry : filesystem.getRoot()) {
            POIFSDocumentType type = POIFSDocumentType.detectType(entry);
            if (type != POIFSDocumentType.UNKNOWN) {
                this.setType(metadata, type.getType());
            }
            switch (type) {
                case PUBLISHER: {
                    PublisherTextExtractor publisherTextExtractor = new PublisherTextExtractor(filesystem);
                    xhtml.element("p", publisherTextExtractor.getText());
                    break;
                }
                case WORDDOCUMENT: {
                    new WordExtractor(context).parse(filesystem, xhtml);
                    break;
                }
                case POWERPOINT: {
                    PowerPointExtractor powerPointExtractor = new PowerPointExtractor(filesystem);
                    xhtml.element("p", powerPointExtractor.getText(true, true));
                    break;
                }
                case WORKBOOK: {
                    Locale locale = (Locale)context.get(Locale.class, (Object)Locale.getDefault());
                    new ExcelExtractor(context).parse(filesystem, xhtml, locale);
                    break;
                }
                case VISIO: {
                    VisioTextExtractor visioTextExtractor = new VisioTextExtractor(filesystem);
                    for (String text : visioTextExtractor.getAllText()) {
                        xhtml.element("p", text);
                    }
                    continue block11;
                }
                case OUTLOOK: {
                    if (outlookExtracted) break;
                    outlookExtracted = true;
                    OutlookExtractor extractor = new OutlookExtractor(filesystem, context);
                    extractor.parse(xhtml, metadata);
                    break;
                }
                case ENCRYPTED: {
                    EncryptionInfo info = new EncryptionInfo(filesystem);
                    Decryptor d = new Decryptor(info);
                    try {
                        if (!d.verifyPassword("VelvetSweatshop")) {
                            throw new TikaException("Unable to process: document is encrypted");
                        }
                        OOXMLParser parser = new OOXMLParser();
                        parser.parse(d.getDataStream(filesystem), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), metadata, context);
                        break;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new TikaException("Unable to process encrypted document", (Throwable)ex);
                    }
                }
            }
        }
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private void setType(Metadata metadata, MediaType type) {
        metadata.set("Content-Type", type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum POIFSDocumentType {
        WORKBOOK("xls", MediaType.application((String)"vnd.ms-excel")),
        OLE10_NATIVE("ole", MediaType.application((String)"x-tika-msoffice")),
        WORDDOCUMENT("doc", MediaType.application((String)"msword")),
        UNKNOWN("unknown", MediaType.application((String)"x-tika-msoffice")),
        ENCRYPTED("ole", MediaType.application((String)"x-tika-msoffice")),
        POWERPOINT("ppt", MediaType.application((String)"vnd.ms-powerpoint")),
        PUBLISHER("pub", MediaType.application((String)"x-mspublisher")),
        VISIO("vsd", MediaType.application((String)"vnd.visio")),
        WORKS("wps", MediaType.application((String)"vnd.ms-works")),
        OUTLOOK("msg", MediaType.application((String)"vnd.ms-outlook"));

        private final String extension;
        private final MediaType type;

        private POIFSDocumentType(String extension, MediaType type) {
            this.extension = extension;
            this.type = type;
        }

        public String getExtension() {
            return this.extension;
        }

        public MediaType getType() {
            return this.type;
        }

        public static POIFSDocumentType detectType(POIFSFileSystem fs) {
            return POIFSDocumentType.detectType((DirectoryEntry)fs.getRoot());
        }

        public static POIFSDocumentType detectType(DirectoryEntry node) {
            for (Entry entry : node) {
                POIFSDocumentType type = POIFSDocumentType.detectType(entry);
                if (type == UNKNOWN) continue;
                return type;
            }
            return UNKNOWN;
        }

        public static POIFSDocumentType detectType(Entry entry) {
            String name = entry.getName();
            if ("Workbook".equals(name)) {
                return WORKBOOK;
            }
            if ("EncryptedPackage".equals(name)) {
                return ENCRYPTED;
            }
            if ("WordDocument".equals(name)) {
                return WORDDOCUMENT;
            }
            if ("Quill".equals(name)) {
                return PUBLISHER;
            }
            if ("PowerPoint Document".equals(entry.getName())) {
                return POWERPOINT;
            }
            if ("VisioDocument".equals(entry.getName())) {
                return VISIO;
            }
            if ("CONTENTS".equals(entry.getName())) {
                return WORKS;
            }
            if (entry.getName().startsWith("__substg1.0_")) {
                return OUTLOOK;
            }
            if ("\u0001Ole10Native".equals(name)) {
                return OLE10_NATIVE;
            }
            return UNKNOWN;
        }

        static /* synthetic */ MediaType access$000(POIFSDocumentType x0) {
            return x0.type;
        }
    }
}

