/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.drools.builder.ResourceType;
import org.drools.compiler.DroolsParserException;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.VerifierReportWriter;
import org.drools.verifier.report.VerifierReportWriterFactory;

public class DroolsVerifierAntTask
extends MatchingTask {
    public static final String DRLFILEEXTENSION = ".drl";
    private File srcdir;
    private File toFile;
    private Path classpath;

    public void setSrcDir(File directory) {
        this.srcdir = directory;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.toFile == null) {
            throw new BuildException("Destination rulebase file does not specified.");
        }
        if (this.srcdir == null) {
            throw new BuildException("Source directory not specified.");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("Source directory does not exists." + this.srcdir.getAbsolutePath());
        }
        try {
            Verifier droolsanalyzer = VerifierBuilderFactory.newVerifierBuilder().newVerifier();
            String[] fileNames = this.getFileList();
            for (int i = 0; i < fileNames.length; ++i) {
                this.compileAndAnalyzeFile(droolsanalyzer, fileNames[i]);
            }
            droolsanalyzer.fireAnalysis();
            VerifierReport result = droolsanalyzer.getResult();
            VerifierReportWriter vReportWriter = VerifierReportWriterFactory.newHTMLReportWriter();
            File path = new File(this.toFile, "report.zip");
            FileOutputStream out = new FileOutputStream(path);
            vReportWriter.writeReport((OutputStream)out, result);
            System.out.println("Writing verifier report to " + path);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new BuildException("RuleBaseTask failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void compileAndAnalyzeFile(Verifier droolsVerifier, String filename) throws DroolsParserException {
        if (!filename.endsWith(DRLFILEEXTENSION)) {
            throw new UnsupportedOperationException();
        }
        droolsVerifier.addResourcesToVerify(ResourceFactory.newFileResource((File)new File(this.srcdir.getAbsolutePath(), filename)), ResourceType.DRL);
    }

    private String[] getFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            throw new BuildException("No rule files found in include directory.");
        }
        return fileNames;
    }
}

