/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class DSAParameter
extends ASN1Encodable {
    DERInteger p;
    DERInteger q;
    DERInteger g;

    public static DSAParameter getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DSAParameter getInstance(Object object) {
        if (object == null || object instanceof DSAParameter) {
            return (DSAParameter)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DSAParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DSAParameter: " + object.getClass().getName());
    }

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.g = new DERInteger(bigInteger3);
    }

    public DSAParameter(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.p = DERInteger.getInstance(enumeration.nextElement());
        this.q = DERInteger.getInstance(enumeration.nextElement());
        this.g = DERInteger.getInstance(enumeration.nextElement());
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.g);
        return new DERSequence(aSN1EncodableVector);
    }
}

