/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fork.ForkClient;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ForkParser
extends DelegatingParser {
    private final ClassLoader loader;
    private final Queue<ForkClient> pool = new LinkedList<ForkClient>();
    private int poolSize = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ForkParser parser = new ForkParser(Thread.currentThread().getContextClassLoader());
        try {
            ParseContext context = new ParseContext();
            context.set(Parser.class, new AutoDetectParser());
            parser.parse(null, null, null, context);
        }
        finally {
            parser.close();
        }
    }

    public ForkParser(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ForkClient client = this.acquireClient();
        try {
            System.out.println(client.echo(this.getDelegateParser(context)));
        }
        finally {
            this.releaseClient(client);
        }
    }

    public synchronized void close() {
        for (ForkClient client : this.pool) {
            client.close();
        }
        this.pool.clear();
        this.poolSize = 0;
    }

    private synchronized ForkClient acquireClient() throws IOException {
        ForkClient client = this.pool.poll();
        if (client == null) {
            client = new ForkClient(this.loader);
        }
        return client;
    }

    private synchronized void releaseClient(ForkClient client) {
        if (this.pool.size() < this.poolSize) {
            this.pool.offer(client);
        } else {
            client.close();
        }
    }
}

