/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.DroolsDebugViewContentProvider;
import org.drools.eclipse.debug.ObjectWrapper;
import org.drools.eclipse.debug.VariableWrapper;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class AgendaViewContentProvider
extends DroolsDebugViewContentProvider {
    private DroolsDebugEventHandlerView view;

    public AgendaViewContentProvider(DroolsDebugEventHandlerView view) {
        this.view = view;
    }

    protected String getEmptyString() {
        return "The selected working memory has an empty agenda.";
    }

    public Object[] getChildren(Object obj) {
        try {
            Object[] variables = null;
            if (obj != null && obj instanceof IJavaObject && "org.drools.reteoo.ReteooStatefulSession".equals(((IJavaObject)obj).getReferenceTypeName())) {
                variables = this.getAgendaElements((IJavaObject)obj);
            } else if (obj instanceof IVariable) {
                if (this.view.isShowLogicalStructure()) {
                    IValue value = this.getLogicalValue(((IVariable)obj).getValue(), new ArrayList());
                    variables = value.getVariables();
                }
                if (variables == null) {
                    variables = ((IVariable)obj).getValue().getVariables();
                }
            }
            if (variables == null) {
                return new Object[0];
            }
            this.cache(obj, variables);
            return variables;
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return new Object[0];
        }
    }

    private void testDebugExpression() {
        Object session = null;
        session.getAgenda().getAgendaGroups();
        session.getAgenda().getFocusName();
    }

    private Object[] getAgendaElements(IJavaObject workingMemoryImpl) throws DebugException {
        ArrayList<MyVariableWrapper> result = new ArrayList<MyVariableWrapper>();
        IValue agendaGroupObjects = DebugUtil.getValueByExpression("return getAgenda().getAgendaGroups();", (IValue)workingMemoryImpl);
        IValue focus = DebugUtil.getValueByExpression("return getAgenda().getFocus();", (IValue)workingMemoryImpl);
        if (focus == null) {
            focus = DebugUtil.getValueByExpression("return getAgenda().getFocusName();", (IValue)workingMemoryImpl);
        }
        if (agendaGroupObjects instanceof IJavaArray) {
            IJavaArray agendaGroupArray = (IJavaArray)agendaGroupObjects;
            IJavaValue[] agendaGroupValueArray = agendaGroupArray.getValues();
            int i = 0;
            while (i < agendaGroupValueArray.length) {
                IJavaValue agendaGroup = agendaGroupValueArray[i];
                String name = "";
                ArrayList<VariableWrapper> activationsResult = new ArrayList<VariableWrapper>();
                IVariable[] agendaGroupVarArray = agendaGroup.getVariables();
                int j = 0;
                while (j < agendaGroupVarArray.length) {
                    IVariable agendaGroupVar = agendaGroupVarArray[j];
                    if ("name".equals(agendaGroupVar.getName())) {
                        name = agendaGroupVar.getValue().getValueString();
                        break;
                    }
                    ++j;
                }
                IJavaArray activations = (IJavaArray)DebugUtil.getValueByExpression("return getActivations();", (IValue)agendaGroup);
                IJavaValue[] activationArray = activations.getValues();
                int l = 0;
                while (l < activationArray.length) {
                    IJavaValue activation = activationArray[l];
                    if (activation.getJavaType() != null) {
                        activationsResult.add(new VariableWrapper("[" + l + "]", (IJavaValue)new LazyActivationWrapper((IJavaObject)activations, activation, workingMemoryImpl)));
                    }
                    ++l;
                }
                boolean active = false;
                if (agendaGroup.equals(focus)) {
                    active = true;
                }
                name = this.replaceSpaces(name);
                result.add(new MyVariableWrapper(String.valueOf(name) + "[" + (active ? "focus" : "nofocus") + "]", (IJavaValue)new ObjectWrapper((IJavaObject)agendaGroup, activationsResult.toArray(new IJavaVariable[activationsResult.size()]))));
                ++i;
            }
        }
        return result.toArray(new IVariable[0]);
    }

    private String replaceSpaces(String name) {
        return name.replace(' ', '_');
    }

    private class LazyActivationWrapper
    extends ObjectWrapper {
        private IJavaValue activation;
        private IJavaValue workingMemoryImpl;

        public LazyActivationWrapper(IJavaObject object, IJavaValue activation, IJavaObject workingMemoryImpl) {
            super(object, null);
            this.activation = activation;
            this.workingMemoryImpl = workingMemoryImpl;
        }

        public IVariable[] getVariables() {
            IVariable[] result = super.getVariables();
            if (result == null) {
                try {
                    IValue objects;
                    ArrayList<VariableWrapper> variables = new ArrayList<VariableWrapper>();
                    variables.add(new VariableWrapper("ruleName", (IJavaValue)DebugUtil.getValueByExpression("return getRule().getName();", (IValue)this.activation)));
                    String activationId = null;
                    IVariable[] activationVarArray = this.activation.getVariables();
                    int j = 0;
                    while (j < activationVarArray.length) {
                        IVariable activationVar = activationVarArray[j];
                        if ("activationNumber".equals(activationVar.getName())) {
                            activationId = activationVar.getValue().getValueString();
                            break;
                        }
                        ++j;
                    }
                    if (activationId != null && (objects = DebugUtil.getValueByExpression("return getActivationParameters(" + activationId + ");", (IValue)this.workingMemoryImpl)) instanceof IJavaArray) {
                        IJavaArray array = (IJavaArray)objects;
                        IJavaValue[] javaVals = array.getValues();
                        int k = 0;
                        while (k < javaVals.length) {
                            IJavaValue mapEntry = javaVals[k];
                            String key = null;
                            IJavaValue value = null;
                            IVariable[] vars = mapEntry.getVariables();
                            int j2 = 0;
                            while (j2 < vars.length) {
                                IVariable var = vars[j2];
                                if ("key".equals(var.getName())) {
                                    key = var.getValue().getValueString();
                                } else if ("value".equals(var.getName())) {
                                    value = (IJavaValue)var.getValue();
                                }
                                ++j2;
                            }
                            variables.add(new VariableWrapper(key, value));
                            ++k;
                        }
                        result = variables.toArray(new IJavaVariable[variables.size()]);
                    }
                }
                catch (Throwable t) {
                    DroolsEclipsePlugin.log(t);
                }
                if (result == null) {
                    result = new IJavaVariable[]{};
                }
                this.setVariables((IJavaVariable[])result);
            }
            return result;
        }

        public boolean hasVariables() {
            return true;
        }

        public String getValueString() throws DebugException {
            return "Activation";
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }
    }

    private class MyVariableWrapper
    extends VariableWrapper {
        public MyVariableWrapper(String name, IJavaValue value) {
            super(name, value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof VariableWrapper) {
                VariableWrapper var = (VariableWrapper)((Object)obj);
                return var.getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

