/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event;

import javax.persistence.EntityManager;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.event.DefaultTaskEventListener;
import org.jbpm.task.event.TaskClaimedEvent;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskFailedEvent;
import org.jbpm.task.event.TaskSkippedEvent;
import org.jbpm.task.service.TaskServiceSession;

public class InternalTaskEventListener
extends DefaultTaskEventListener {
    private TaskServiceSession session;
    private EntityManager em;

    public InternalTaskEventListener(TaskServiceSession session) {
        this.session = session;
        this.em = session.getEntityManager();
    }

    public void taskClaimed(TaskClaimedEvent event) {
    }

    public void taskCompleted(TaskCompletedEvent event) {
        if (!this.em.getTransaction().isActive()) {
            this.em.getTransaction().begin();
        }
        Task task = this.session.getTask(event.getTaskId());
        task.getTaskData().setStatus(Status.Completed);
        this.em.persist((Object)task);
        this.em.getTransaction().commit();
    }

    public void taskFailed(TaskFailedEvent event) {
    }

    public void taskSkipped(TaskSkippedEvent event) {
    }
}

