/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.userprofile;

import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;
import org.jbpm.userprofile.Group;
import org.jbpm.userprofile.User;
import org.jbpm.userprofile.UserProfile;
import org.jbpm.userprofile.UserProfileRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Startup
@Name(value="userProfileManager")
public class UserProfileManager {
    UserProfileRepository userProfileRepository = null;

    public User getUser() {
        String userName = "";
        if (Contexts.isApplicationContextActive()) {
            userName = Identity.instance().getCredentials().getUsername();
        }
        return this.getUser(userName);
    }

    public User getUser(String userId) {
        if (this.userProfileRepository == null) {
            return null;
        }
        User user = new User();
        UserProfile profile = this.userProfileRepository.getUserProfile(userId);
        user.setUserProfile(profile);
        user.setId(profile.getID());
        return user;
    }

    public void updateUser(User user) {
        if (this.userProfileRepository == null) {
            return;
        }
        this.userProfileRepository.setUserProfile(user.getUserProfile());
    }

    public List<User> getUsers() {
        if (this.userProfileRepository == null) {
            return null;
        }
        return this.userProfileRepository.getUsers();
    }

    public String[] getUserIds() {
        if (this.userProfileRepository == null) {
            return null;
        }
        return this.userProfileRepository.getUserIds();
    }

    public List<Group> getGroups() {
        if (this.userProfileRepository == null) {
            return null;
        }
        return this.userProfileRepository.getGroups();
    }

    public String[] getGroupIds() {
        if (this.userProfileRepository == null) {
            return null;
        }
        return this.userProfileRepository.getUserIds();
    }

    public List<Group> getGroupsForUser(String userId) {
        return null;
    }

    public List<Group> getFlattenedGroupsForUser(String userId) {
        return null;
    }

    public UserProfileRepository getUserProfileRepository() {
        return this.userProfileRepository;
    }

    public void setUserProfileRepository(UserProfileRepository userProfileRepository) {
        this.userProfileRepository = userProfileRepository;
    }
}

