/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.cnd;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.commons.cnd.TemplateBuilderFactory;

public final class CndImporter {
    private CndImporter() {
    }

    public static NodeType[] registerNodeTypes(Reader cnd, Session session) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, ParseException, RepositoryException, IOException {
        Workspace wsp = session.getWorkspace();
        return CndImporter.registerNodeTypes(cnd, "cnd input stream", wsp.getNodeTypeManager(), wsp.getNamespaceRegistry(), session.getValueFactory(), false);
    }

    public static NodeType[] registerNodeTypes(Reader cnd, Session session, boolean reregisterExisting) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, ParseException, RepositoryException, IOException {
        Workspace wsp = session.getWorkspace();
        return CndImporter.registerNodeTypes(cnd, "cnd input stream", wsp.getNodeTypeManager(), wsp.getNamespaceRegistry(), session.getValueFactory(), reregisterExisting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeType[] registerNodeTypes(Reader cnd, String systemId, NodeTypeManager nodeTypeManager, NamespaceRegistry namespaceRegistry, ValueFactory valueFactory, boolean reregisterExisting) throws ParseException, InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException, IOException {
        try {
            NodeTypeIterator registered;
            TemplateBuilderFactory factory = new TemplateBuilderFactory(nodeTypeManager, valueFactory, namespaceRegistry);
            CompactNodeTypeDefReader<NodeTypeTemplate, NamespaceRegistry> cndReader = new CompactNodeTypeDefReader<NodeTypeTemplate, NamespaceRegistry>(cnd, systemId, factory);
            List<NodeTypeTemplate> ntts = cndReader.getNodeTypeDefinitions();
            if (reregisterExisting) {
                registered = nodeTypeManager.registerNodeTypes((NodeTypeDefinition[])ntts.toArray(new NodeTypeTemplate[ntts.size()]), true);
            } else {
                ArrayList<NodeTypeTemplate> toRegister = new ArrayList<NodeTypeTemplate>(ntts.size());
                for (NodeTypeTemplate ntt : ntts) {
                    if (nodeTypeManager.hasNodeType(ntt.getName())) continue;
                    toRegister.add(ntt);
                }
                registered = nodeTypeManager.registerNodeTypes((NodeTypeDefinition[])toRegister.toArray(new NodeTypeTemplate[toRegister.size()]), true);
            }
            NodeType[] nodeTypeArray = CndImporter.toArray(registered);
            return nodeTypeArray;
        }
        finally {
            cnd.close();
        }
    }

    private static NodeType[] toArray(NodeTypeIterator nodeTypes) {
        ArrayList<NodeType> nts = new ArrayList<NodeType>();
        while (nodeTypes.hasNext()) {
            nts.add(nodeTypes.nextNodeType());
        }
        return nts.toArray(new NodeType[nts.size()]);
    }
}

