/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.IoWorkerRunnable;

public class DefaultChannelFuture
implements ChannelFuture {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelFuture.class);
    private static final Throwable CANCELLED = new Throwable();
    private static volatile boolean useDeadLockChecker = true;
    private static boolean disabledDeadLockCheckerOnce;
    private final Channel channel;
    private final boolean cancellable;
    private volatile ChannelFutureListener firstListener;
    private volatile List<ChannelFutureListener> otherListeners;
    private boolean done;
    private Throwable cause;
    private int waiters;

    public static boolean isUseDeadLockChecker() {
        return useDeadLockChecker;
    }

    public static void setUseDeadLockChecker(boolean useDeadLockChecker) {
        if (!useDeadLockChecker && !disabledDeadLockCheckerOnce) {
            disabledDeadLockCheckerOnce = true;
            logger.debug("The dead lock checker in " + DefaultChannelFuture.class.getSimpleName() + " has been disabled as requested at your own risk.");
        }
        DefaultChannelFuture.useDeadLockChecker = useDeadLockChecker;
    }

    public DefaultChannelFuture(Channel channel, boolean cancellable) {
        this.channel = channel;
        this.cancellable = cancellable;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean isSuccess() {
        return this.done && this.cause == null;
    }

    public synchronized Throwable getCause() {
        if (this.cause != CANCELLED) {
            return this.cause;
        }
        return null;
    }

    public synchronized boolean isCancelled() {
        return this.cause == CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<ChannelFutureListener>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (!this.done) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            while (!this.done) {
                Object var3_2;
                this.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                    var3_2 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
        }
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ChannelFuture awaitUninterruptibly() {
        boolean interrupted = false;
        DefaultChannelFuture defaultChannelFuture = this;
        // MONITORENTER : defaultChannelFuture
        while (true) {
            Object var5_4;
            if (this.done) {
                // MONITOREXIT : defaultChannelFuture
                if (!interrupted) return this;
                Thread.currentThread().interrupt();
                return this;
            }
            this.checkDeadLock();
            ++this.waiters;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    var5_4 = null;
                    --this.waiters;
                    continue;
                }
                var5_4 = null;
                --this.waiters;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                --this.waiters;
                throw throwable;
            }
        }
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        block21: {
            block20: {
                block19: {
                    if (interruptable && Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
                    waitTime = timeoutNanos;
                    interrupted = false;
                    try {
                        var9_6 = this;
                        synchronized (var9_6) {
                            if (this.done) {
                                var10_7 = this.done;
                                // MONITOREXIT @DISABLED, blocks:[16, 0, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var9_6
                                var15_12 = null;
                                if (interrupted == false) return var10_7;
                                Thread.currentThread().interrupt();
                                return var10_7;
                            }
                            if (waitTime <= 0L) {
                                var10_8 = this.done;
                                // MONITOREXIT @DISABLED, blocks:[0, 18, 8] lbl19 : MonitorExitStatement: MONITOREXIT : var9_6
                                break block19;
                            }
                            this.checkDeadLock();
                            ++this.waiters;
                            while (true) {
                                try {
                                    try {
                                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                                    }
                                    catch (InterruptedException e) {
                                        if (interruptable) {
                                            throw e;
                                        }
                                        interrupted = true;
                                    }
                                    if (!this.done) continue;
                                    var10_10 = true;
                                    var12_17 = null;
                                    --this.waiters;
                                    break block20;
                                }
                                catch (Throwable var11_20) {
                                    var12_19 = null;
                                    --this.waiters;
                                    throw var11_20;
                                }
                                break;
                            }
                            {
                                if ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L) ** continue;
                                var10_11 = this.done;
                                var12_18 = null;
                                --this.waiters;
                            }
                        }
                        break block21;
                    }
                    catch (Throwable var14_21) {
                        var15_16 = null;
                        if (interrupted == false) throw var14_21;
                        Thread.currentThread().interrupt();
                        throw var14_21;
                    }
                }
                var15_13 = null;
                if (interrupted == false) return var10_8;
                Thread.currentThread().interrupt();
                return var10_8;
            }
            var15_14 = null;
            if (interrupted == false) return var10_10;
            Thread.currentThread().interrupt();
            return var10_10;
        }
        var15_15 = null;
        if (interrupted == false) return var10_11;
        Thread.currentThread().interrupt();
        return var10_11;
    }

    private void checkDeadLock() {
        if (DefaultChannelFuture.isUseDeadLockChecker() && IoWorkerRunnable.IN_IO_THREAD.get().booleanValue()) {
            throw new IllegalStateException("await*() in I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSuccess() {
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFailure(Throwable cause) {
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.cause = cause;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (!this.cancellable) {
            return false;
        }
        DefaultChannelFuture defaultChannelFuture = this;
        synchronized (defaultChannelFuture) {
            if (this.done) {
                return false;
            }
            this.cause = CANCELLED;
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (ChannelFutureListener l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(ChannelFutureListener l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + ".", t);
        }
    }
}

