/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.container.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalClientChannelFactory;
import org.jboss.netty.channel.local.LocalServerChannelFactory;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.container.guice.ChannelFactoryResource;
import org.jboss.netty.container.guice.NioClientSocketChannelFactoryProvider;
import org.jboss.netty.container.guice.NioDatagramChannelFactoryProvider;
import org.jboss.netty.container.guice.NioServerSocketChannelFactoryProvider;
import org.jboss.netty.container.guice.OioClientSocketChannelFactoryProvider;
import org.jboss.netty.container.guice.OioDatagramChannelFactoryProvider;
import org.jboss.netty.container.guice.OioServerSocketChannelFactoryProvider;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.jboss.netty.util.internal.UnterminatableExecutor;

public class NettyModule
extends AbstractModule {
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public void destroy() {
        ExecutorUtil.terminate(this.executor);
    }

    protected void configure() {
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("Executor has been shut down already.");
        }
        UnterminatableExecutor executor = new UnterminatableExecutor(this.executor);
        this.bind(Executor.class).annotatedWith(ChannelFactoryResource.class).toInstance((Object)executor);
        this.bind(ClientSocketChannelFactory.class).toProvider(NioClientSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(ServerSocketChannelFactory.class).toProvider(NioServerSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(DatagramChannelFactory.class).toProvider(OioDatagramChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(NioClientSocketChannelFactory.class).toProvider(NioClientSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(NioServerSocketChannelFactory.class).toProvider(NioServerSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(NioDatagramChannelFactory.class).toProvider(NioDatagramChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(OioClientSocketChannelFactory.class).toProvider(OioClientSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(OioServerSocketChannelFactory.class).toProvider(OioServerSocketChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(OioDatagramChannelFactory.class).toProvider(OioDatagramChannelFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(LocalClientChannelFactory.class).to(DefaultLocalClientChannelFactory.class).in(Scopes.SINGLETON);
        this.bind(LocalServerChannelFactory.class).to(DefaultLocalServerChannelFactory.class).in(Scopes.SINGLETON);
        this.bind(DefaultLocalClientChannelFactory.class).to(DefaultLocalClientChannelFactory.class).in(Scopes.SINGLETON);
        this.bind(DefaultLocalServerChannelFactory.class).to(DefaultLocalServerChannelFactory.class).in(Scopes.SINGLETON);
    }
}

