/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.container.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalClientChannelFactory;
import org.jboss.netty.channel.local.LocalServerChannelFactory;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.OsgiLoggerFactory;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyBundleActivator
implements BundleActivator {
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private Executor executor;
    private OsgiLoggerFactory loggerFactory;

    public void start(BundleContext ctx) throws Exception {
        this.loggerFactory = new OsgiLoggerFactory(ctx);
        InternalLoggerFactory.setDefaultFactory(this.loggerFactory);
        this.executor = Executors.newCachedThreadPool();
        ExecutorService executor = this.executor;
        this.register(ctx, new NioClientSocketChannelFactory(executor, executor), ClientSocketChannelFactory.class);
        this.register(ctx, new NioServerSocketChannelFactory(executor, executor), ServerSocketChannelFactory.class);
        this.register(ctx, new OioDatagramChannelFactory(executor), DatagramChannelFactory.class);
        this.register(ctx, new DefaultLocalClientChannelFactory(), LocalClientChannelFactory.class);
        this.register(ctx, new DefaultLocalServerChannelFactory(), LocalServerChannelFactory.class);
        this.register(ctx, new OioClientSocketChannelFactory(executor), new Class[0]);
        this.register(ctx, new OioServerSocketChannelFactory(executor, executor), new Class[0]);
        this.register(ctx, new NioDatagramChannelFactory(executor), new Class[0]);
    }

    public void stop(BundleContext ctx) throws Exception {
        this.unregisterAll();
        if (this.executor != null) {
            ExecutorUtil.terminate(this.executor);
            this.executor = null;
        }
        if (this.loggerFactory != null) {
            InternalLoggerFactory.setDefaultFactory(this.loggerFactory.getFallback());
            this.loggerFactory.destroy();
            this.loggerFactory = null;
        }
    }

    private void register(BundleContext ctx, ChannelFactory factory, Class<?> ... factoryTypes) {
        Properties props = new Properties();
        props.setProperty("category", "netty");
        this.registrations.add(ctx.registerService(factory.getClass().getName(), (Object)factory, (Dictionary)props));
        for (Class<?> t : factoryTypes) {
            this.registrations.add(ctx.registerService(t.getName(), (Object)factory, (Dictionary)props));
        }
    }

    private void unregisterAll() {
        ArrayList<ServiceRegistration> registrationsCopy = new ArrayList<ServiceRegistration>(this.registrations);
        this.registrations.clear();
        for (ServiceRegistration r : registrationsCopy) {
            r.unregister();
        }
    }
}

