/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.container.spring;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.logging.CommonsLoggerFactory;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.jboss.netty.util.internal.UnterminatableExecutor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NettyResourceFactory
implements InitializingBean,
DisposableBean {
    private Executor executor;
    private Executor unterminatableExecutor;

    public synchronized void afterPropertiesSet() {
        if (this.executor != null) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        this.unterminatableExecutor = new UnterminatableExecutor(this.executor);
        InternalLoggerFactory.setDefaultFactory(new CommonsLoggerFactory());
    }

    public synchronized void destroy() {
        if (this.executor != null) {
            ExecutorUtil.terminate(this.executor);
        }
        this.executor = null;
        this.unterminatableExecutor = null;
    }

    public synchronized Executor getChannelFactoryExecutor() {
        return this.unterminatableExecutor;
    }
}

