/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;

public class DescendantPathNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap contextIndex = new ScoreNodeMap();
    private final HierarchyManager hmgr;

    public DescendantPathNodeJoin(MultiColumnQueryHits context, Name contextSelectorName, Path relPath, HierarchyManager hmgr) throws IOException {
        super(context);
        ScoreNode[] nodes;
        this.hmgr = hmgr;
        int idx = DescendantPathNodeJoin.getIndex(context, contextSelectorName);
        while ((nodes = context.nextScoreNodes()) != null) {
            try {
                Path p = hmgr.getPath(nodes[idx].getNodeId());
                PathBuilder builder = new PathBuilder(p);
                builder.addAll(relPath.getElements());
                p = builder.getPath().getNormalizedPath();
                this.contextIndex.addScoreNodes(p, nodes);
            }
            catch (RepositoryException e) {}
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode descendant) throws IOException {
        try {
            Path p = this.hmgr.getPath(descendant.getNodeId());
            return this.contextIndex.getScoreNodes(p);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }
}

