/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import org.apache.poi.hsmf.datatypes.StringChunk;

public final class Chunks
implements ChunkGroup {
    public static final int MESSAGE_CLASS = 26;
    public static final int SUBJECT = 55;
    public static final int SUBMISSION_ID_DATE = 71;
    public static final int CONVERSATION_TOPIC = 112;
    public static final int SENT_BY_SERVER_TYPE = 117;
    public static final int MESSAGE_HEADERS = 125;
    public static final int DISPLAY_TO = 3588;
    public static final int DISPLAY_FROM = 3098;
    public static final int EMAIL_FROM = 3103;
    public static final int DISPLAY_CC = 3587;
    public static final int DISPLAY_BCC = 3586;
    public static final int TEXT_BODY = 4096;
    public static final int MESSAGE_ID = 4149;
    private List<Chunk> allChunks = new ArrayList<Chunk>();
    public StringChunk messageClass;
    public StringChunk textBodyChunk;
    public StringChunk subjectChunk;
    public StringChunk displayToChunk;
    public StringChunk displayFromChunk;
    public StringChunk displayCCChunk;
    public StringChunk displayBCCChunk;
    public StringChunk conversationTopic;
    public StringChunk sentByServerType;
    public StringChunk messageHeaders;
    public MessageSubmissionChunk submissionChunk;
    public StringChunk emailFromChunk;
    public StringChunk messageId;

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    public Chunk[] getChunks() {
        return this.getAll();
    }

    public void record(Chunk chunk) {
        switch (chunk.getChunkId()) {
            case 26: {
                this.messageClass = (StringChunk)chunk;
                break;
            }
            case 4149: {
                this.messageId = (StringChunk)chunk;
                break;
            }
            case 55: {
                this.subjectChunk = (StringChunk)chunk;
                break;
            }
            case 71: {
                this.submissionChunk = (MessageSubmissionChunk)chunk;
                break;
            }
            case 112: {
                this.conversationTopic = (StringChunk)chunk;
                break;
            }
            case 117: {
                this.sentByServerType = (StringChunk)chunk;
                break;
            }
            case 125: {
                this.messageHeaders = (StringChunk)chunk;
                break;
            }
            case 3588: {
                this.displayToChunk = (StringChunk)chunk;
                break;
            }
            case 3098: {
                this.displayFromChunk = (StringChunk)chunk;
                break;
            }
            case 3103: {
                this.emailFromChunk = (StringChunk)chunk;
                break;
            }
            case 3587: {
                this.displayCCChunk = (StringChunk)chunk;
                break;
            }
            case 3586: {
                this.displayBCCChunk = (StringChunk)chunk;
                break;
            }
            case 4096: {
                this.textBodyChunk = (StringChunk)chunk;
            }
        }
        this.allChunks.add(chunk);
    }
}

