/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.verifier.misc.Comment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrlRuleParser {
    private static final String rulesExpr = "(^\\s*#.*?\\n)?(^\\s*rule.*?$)(.*?)(when)(.*?)(then)(.*?)(^\\s*end)";
    private static final Pattern finder = Pattern.compile("(^\\s*#.*?\\n)?(^\\s*rule.*?$)(.*?)(when)(.*?)(then)(.*?)(^\\s*end)", 40);
    private final Collection<String> header;
    private final Collection<String> lhs;
    private final Collection<String> rhs;
    private final String name;
    private final String description;
    private final Collection<String> metadata;
    private final Map<String, List<String>> otherInformation;

    private DrlRuleParser(String ruleName, String header, String lhs, String rhs, String description, List<String> metadata, Map<String, List<String>> otherInformation) {
        this.name = ruleName;
        this.header = this.asList(header.split("\n"));
        this.lhs = this.asList(lhs.split("\n"));
        this.rhs = this.asList(rhs.split("\n"));
        this.description = description;
        this.metadata = metadata;
        this.otherInformation = otherInformation;
    }

    private Collection<String> asList(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            String string = array[i];
            if (string.trim().equals("")) continue;
            list.add(string);
        }
        return list;
    }

    public static List<DrlRuleParser> findRulesDataFromDrl(String drl) {
        Matcher m = finder.matcher(drl);
        ArrayList<DrlRuleParser> list = new ArrayList<DrlRuleParser>();
        while (m.find()) {
            Comment comment = DrlRuleParser.processComment(m.group(1));
            String ruleName = m.group(2);
            ruleName = DrlRuleParser.trimRuleName(ruleName);
            list.add(new DrlRuleParser(ruleName, m.group(3), m.group(5), m.group(7), comment.description, comment.metadata, new HashMap<String, List<String>>()));
        }
        return list;
    }

    private static String trimRuleName(String ruleName) {
        if ((ruleName = ruleName.substring(ruleName.indexOf("rule") + "rule".length()).trim()).indexOf("\"") == 0) {
            ruleName = ruleName.substring(1);
        }
        if (ruleName.lastIndexOf("\"") == ruleName.length() - 1) {
            ruleName = ruleName.substring(0, ruleName.length() - 1);
        }
        return ruleName;
    }

    static Comment processComment(String text) {
        Comment comment = new Comment();
        if (text == null) {
            comment.description = "";
            comment.metadata = new ArrayList<String>();
            return comment;
        }
        StringBuilder description = new StringBuilder();
        String[] commentLines = text.split("\n");
        for (int i = 0; i < commentLines.length; ++i) {
            String line = commentLines[i].trim();
            if (line.startsWith("#")) {
                while (line.startsWith("#")) {
                    line = line.substring(1);
                }
                if ((line = line.trim()).startsWith("@")) continue;
                description.append(line);
                description.append("\n");
                continue;
            }
            description.delete(0, description.length());
        }
        comment.description = description.toString();
        comment.metadata = DrlRuleParser.findMetaData(text);
        return comment;
    }

    private static List<String> findMetaData(String text) {
        ArrayList<String> list = new ArrayList<String>();
        while (text.contains("@")) {
            int start = text.indexOf(64);
            text = text.substring(start + 1);
            int end = text.indexOf("\n");
            list.add(text.substring(0, end));
            text = text.substring(end);
        }
        return list;
    }

    public Collection<String> getHeader() {
        return this.header;
    }

    public Collection<String> getLhs() {
        return this.lhs;
    }

    public Collection<String> getRhs() {
        return this.rhs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<String> getMetadata() {
        return this.metadata;
    }

    public Map<String, List<String>> getOtherInformation() {
        return this.otherInformation;
    }
}

