/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.io.ProxyInputStream;
import org.apache.tika.io.TaggedIOException;

public class TaggedInputStream
extends ProxyInputStream {
    public TaggedInputStream(InputStream proxy) {
        super(proxy);
    }

    public boolean isCauseOf(IOException exception) {
        if (exception instanceof TaggedIOException) {
            TaggedIOException tagged = (TaggedIOException)exception;
            return this == tagged.getTag();
        }
        return false;
    }

    public void throwIfCauseOf(Exception exception) throws IOException {
        TaggedIOException tagged;
        if (exception instanceof TaggedIOException && this == (tagged = (TaggedIOException)exception).getTag()) {
            throw tagged.getCause();
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this);
    }
}

