/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.List;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.process.workitem.wsht.BlockingAddTaskResponseHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.responsehandlers.BlockingAddAttachmentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingAddCommentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingDeleteAttachmentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingDeleteCommentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingQueryGenericResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingSetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public class AsyncTaskServiceWrapper
implements TaskService {
    private int timeout = 10000;
    private AsyncTaskService taskService;

    public AsyncTaskServiceWrapper(AsyncTaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public void activate(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.activate(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void addAttachment(long taskId, Attachment attachment, Content content) {
        BlockingAddAttachmentResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingAddAttachmentResponseHandler();
            this.taskService.addAttachment(taskId, attachment, content, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
        attachment.setId(responseHandler.getAttachmentId());
        content.setId(responseHandler.getContentId());
    }

    @Override
    public void addComment(long taskId, Comment comment) {
        BlockingAddCommentResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingAddCommentResponseHandler();
            this.taskService.addComment(taskId, comment, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
        comment.setId(responseHandler.getCommentId());
    }

    @Override
    public void addTask(Task task, ContentData content) {
        BlockingAddTaskResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingAddTaskResponseHandler();
            this.taskService.addTask(task, content, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
        task.setId(responseHandler.getTaskId());
    }

    @Override
    public void claim(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.claim(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void claim(long taskId, String userId, List<String> groupIds) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.claim(taskId, userId, groupIds, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void complete(long taskId, String userId, ContentData outputData) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.complete(taskId, userId, outputData, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public boolean connect() {
        return this.taskService.connect();
    }

    @Override
    public boolean connect(String address, int port) {
        return this.taskService.connect(address, port);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.delegate(taskId, userId, targetUserId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId, long contentId) {
        BlockingDeleteAttachmentResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingDeleteAttachmentResponseHandler();
            this.taskService.deleteAttachment(taskId, attachmentId, contentId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void deleteComment(long taskId, long commentId) {
        BlockingDeleteCommentResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingDeleteCommentResponseHandler();
            this.taskService.deleteComment(taskId, commentId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.deleteFault(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.deleteOutput(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void disconnect() throws Exception {
        this.taskService.disconnect();
    }

    @Override
    public void exit(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.exit(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void fail(long taskId, String userId, FaultData faultData) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.fail(taskId, userId, faultData, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.forward(taskId, userId, targetEntityId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public Content getContent(long contentId) {
        BlockingGetContentResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingGetContentResponseHandler();
            this.taskService.getContent(contentId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getContent();
    }

    @Override
    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getSubTasksAssignedAsPotentialOwner(parentId, userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getSubTasksByParent(long parentId) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getSubTasksByParent(parentId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public Task getTask(long taskId) {
        BlockingGetTaskResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingGetTaskResponseHandler();
            this.taskService.getTask(taskId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getTask();
    }

    @Override
    public Task getTaskByWorkItemId(long workItemId) {
        BlockingGetTaskResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingGetTaskResponseHandler();
            this.taskService.getTaskByWorkItemId(workItemId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getTask();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsBusinessAdministrator(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsExcludedOwner(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsPotentialOwner(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsPotentialOwner(userId, groupIds, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResult, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsRecipient(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsTaskInitiator(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsTaskStakeholder(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksOwned(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.nominate(taskId, userId, potentialOwners, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    @Deprecated
    public List<?> query(String qlString, Integer size, Integer offset) {
        BlockingQueryGenericResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingQueryGenericResponseHandler();
            this.taskService.query(qlString, size, offset, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public void register(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.register(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void registerForEvent(EventKey key, boolean remove, EventResponseHandler responseHandler) {
        this.taskService.registerForEvent(key, remove, responseHandler);
    }

    @Override
    public void unregisterForEvent(EventKey key) {
        this.taskService.unregisterForEvent(key);
    }

    @Override
    public void release(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.release(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void remove(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.remove(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void resume(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.resume(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void setDocumentContent(long taskId, Content content) {
        BlockingSetContentResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingSetContentResponseHandler();
            this.taskService.setDocumentContent(taskId, content, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        content.setId(responseHandler.getContentId());
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.setFault(taskId, userId, fault, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void setOutput(long taskId, String userId, ContentData outputContentData) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.setOutput(taskId, userId, outputContentData, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void setPriority(long taskId, String userId, int priority) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.setPriority(taskId, userId, priority, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void skip(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.skip(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void start(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.start(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void stop(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.stop(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void suspend(long taskId, String userId) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.suspend(taskId, userId, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.claimNextAvailable(userId, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        BlockingTaskOperationResponseHandler responseHandler;
        block3: {
            responseHandler = new BlockingTaskOperationResponseHandler();
            this.taskService.claimNextAvailable(userId, groupIds, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block3;
                throw responseHandler.getError();
            }
        }
        if (!responseHandler.isDone()) {
            throw new RuntimeException("Task operation request timed out");
        }
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksByStatusByProcessId(long processInstanceId, List<Status> status, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksByStatusByProcessId(processInstanceId, status, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }

    @Override
    public List<TaskSummary> getTasksByStatusByProcessIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language) {
        BlockingTaskSummaryResponseHandler responseHandler;
        block2: {
            responseHandler = new BlockingTaskSummaryResponseHandler();
            this.taskService.getTasksByStatusByProcessIdByTaskName(processInstanceId, status, taskName, language, responseHandler);
            try {
                responseHandler.waitTillDone(this.timeout);
            }
            catch (Exception e) {
                if (responseHandler.getError() == null) break block2;
                throw responseHandler.getError();
            }
        }
        return responseHandler.getResults();
    }
}

