/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import org.jboss.netty.buffer.AbstractChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.buffer.SlicedChannelBuffer;
import org.jboss.netty.buffer.TruncatedChannelBuffer;

public class CompositeChannelBuffer
extends AbstractChannelBuffer {
    private final ChannelBuffer[] slices;
    private final ByteOrder order;
    private final int[] indices;
    private int lastSliceId;

    public CompositeChannelBuffer(ChannelBuffer ... buffers) {
        int i;
        if (buffers.length == 0) {
            throw new IllegalArgumentException("buffers should not be empty.");
        }
        ByteOrder expectedEndianness = null;
        for (ChannelBuffer buffer : buffers) {
            if (buffer.capacity() == 0) continue;
            expectedEndianness = buffer.order();
        }
        if (expectedEndianness == null) {
            throw new IllegalArgumentException("buffers have only empty buffers.");
        }
        this.order = expectedEndianness;
        this.slices = new ChannelBuffer[buffers.length];
        for (i = 0; i < buffers.length; ++i) {
            if (buffers[i].capacity() != 0 && buffers[i].order() != expectedEndianness) {
                throw new IllegalArgumentException("All buffers must have the same endianness.");
            }
            this.slices[i] = buffers[i].slice();
        }
        this.indices = new int[buffers.length + 1];
        for (i = 1; i <= buffers.length; ++i) {
            this.indices[i] = this.indices[i - 1] + this.slices[i - 1].capacity();
        }
        this.writerIndex(this.capacity());
    }

    private CompositeChannelBuffer(CompositeChannelBuffer buffer) {
        this.order = buffer.order;
        this.slices = (ChannelBuffer[])buffer.slices.clone();
        this.indices = (int[])buffer.indices.clone();
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    public ByteOrder order() {
        return this.order;
    }

    public int capacity() {
        return this.indices[this.slices.length];
    }

    public byte getByte(int index) {
        int sliceId = this.sliceId(index);
        return this.slices[sliceId].getByte(index - this.indices[sliceId]);
    }

    public short getShort(int index) {
        int sliceId = this.sliceId(index);
        if (index + 2 <= this.indices[sliceId + 1]) {
            return this.slices[sliceId].getShort(index - this.indices[sliceId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF);
        }
        return (short)(this.getByte(index) & 0xFF | (this.getByte(index + 1) & 0xFF) << 8);
    }

    public int getUnsignedMedium(int index) {
        int sliceId = this.sliceId(index);
        if (index + 3 <= this.indices[sliceId + 1]) {
            return this.slices[sliceId].getUnsignedMedium(index - this.indices[sliceId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 8 | this.getByte(index + 2) & 0xFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getByte(index + 2) & 0xFF) << 16;
    }

    public int getInt(int index) {
        int sliceId = this.sliceId(index);
        if (index + 4 <= this.indices[sliceId + 1]) {
            return this.slices[sliceId].getInt(index - this.indices[sliceId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 16 | this.getShort(index + 2) & 0xFFFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getShort(index + 2) & 0xFFFF) << 16;
    }

    public long getLong(int index) {
        int sliceId = this.sliceId(index);
        if (index + 8 <= this.indices[sliceId + 1]) {
            return this.slices[sliceId].getLong(index - this.indices[sliceId]);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index) & 0xFFFFFFFFL | ((long)this.getInt(index + 4) & 0xFFFFFFFFL) << 32;
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(int index, ByteBuffer dst) {
        int sliceId = this.sliceId(index);
        int limit = dst.limit();
        int length = dst.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        try {
            while (length > 0) {
                ChannelBuffer s = this.slices[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                dst.limit(dst.position() + localLength);
                s.getBytes(index - adjustment, dst);
                index += localLength;
                length -= localLength;
                ++i;
            }
            Object var11_10 = null;
            dst.limit(limit);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            dst.limit(limit);
            throw throwable;
        }
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return out.write(this.toByteBuffer(index, length));
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, out, localLength);
            index += localLength;
            length -= localLength;
            ++i;
        }
    }

    public void setByte(int index, byte value) {
        int sliceId = this.sliceId(index);
        this.slices[sliceId].setByte(index - this.indices[sliceId], value);
    }

    public void setShort(int index, short value) {
        int sliceId = this.sliceId(index);
        if (index + 2 <= this.indices[sliceId + 1]) {
            this.slices[sliceId].setShort(index - this.indices[sliceId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index, (byte)(value >>> 8));
            this.setByte(index + 1, (byte)value);
        } else {
            this.setByte(index, (byte)value);
            this.setByte(index + 1, (byte)(value >>> 8));
        }
    }

    public void setMedium(int index, int value) {
        int sliceId = this.sliceId(index);
        if (index + 3 <= this.indices[sliceId + 1]) {
            this.slices[sliceId].setMedium(index - this.indices[sliceId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >> 8));
            this.setByte(index + 2, (byte)value);
        } else {
            this.setShort(index, (short)value);
            this.setByte(index + 2, (byte)(value >>> 16));
        }
    }

    public void setInt(int index, int value) {
        int sliceId = this.sliceId(index);
        if (index + 4 <= this.indices[sliceId + 1]) {
            this.slices[sliceId].setInt(index - this.indices[sliceId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >>> 16));
            this.setShort(index + 2, (short)value);
        } else {
            this.setShort(index, (short)value);
            this.setShort(index + 2, (short)(value >>> 16));
        }
    }

    public void setLong(int index, long value) {
        int sliceId = this.sliceId(index);
        if (index + 8 <= this.indices[sliceId + 1]) {
            this.slices[sliceId].setLong(index - this.indices[sliceId], value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index, (int)(value >>> 32));
            this.setInt(index + 4, (int)value);
        } else {
            this.setInt(index, (int)value);
            this.setInt(index + 4, (int)(value >>> 32));
        }
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length || srcIndex > src.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, ByteBuffer src) {
        int sliceId = this.sliceId(index);
        int limit = src.limit();
        int length = src.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        try {
            while (length > 0) {
                ChannelBuffer s = this.slices[i];
                int adjustment = this.indices[i];
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                src.limit(src.position() + localLength);
                s.setBytes(index - adjustment, src);
                index += localLength;
                length -= localLength;
                ++i;
            }
            Object var11_10 = null;
            src.limit(limit);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            src.limit(limit);
            throw throwable;
        }
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length || srcIndex > src.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s;
            int localReadBytes;
            if ((localReadBytes = (s = this.slices[i]).setBytes(index - (adjustment = this.indices[i]), in, localLength = Math.min(length, s.capacity() - (index - adjustment)))) < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        int i = sliceId;
        int readBytes = 0;
        do {
            int localLength;
            int adjustment;
            ChannelBuffer s;
            int localReadBytes;
            if ((localReadBytes = (s = this.slices[i]).setBytes(index - (adjustment = this.indices[i]), in, localLength = Math.min(length, s.capacity() - (index - adjustment)))) == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    public ChannelBuffer duplicate() {
        CompositeChannelBuffer duplicate = new CompositeChannelBuffer(this);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    public ChannelBuffer copy(int index, int length) {
        int sliceId = this.sliceId(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        ChannelBuffer dst = this.factory().getBuffer(this.order(), length);
        this.copyTo(index, length, sliceId, dst);
        return dst;
    }

    private void copyTo(int index, int length, int sliceId, ChannelBuffer dst) {
        int dstIndex = 0;
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        dst.writerIndex(dst.capacity());
    }

    public ChannelBuffer slice(int index, int length) {
        if (index == 0) {
            if (length == 0) {
                return ChannelBuffers.EMPTY_BUFFER;
            }
            return new TruncatedChannelBuffer(this, length);
        }
        if (index < 0 || index > this.capacity() - length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(this, index, length);
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        if (this.slices.length == 1) {
            return this.slices[0].toByteBuffer(index, length);
        }
        ByteBuffer[] buffers = this.toByteBuffers(index, length);
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        for (ByteBuffer b : buffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        int sliceId = this.sliceId(index);
        if (index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.slices.length);
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            buffers.add(s.toByteBuffer(index - adjustment, localLength));
            index += localLength;
            length -= localLength;
            ++i;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    public String toString(int index, int length, String charsetName) {
        int sliceId = this.sliceId(index);
        if (index + length <= this.indices[sliceId + 1]) {
            return this.slices[sliceId].toString(index - this.indices[sliceId], length, charsetName);
        }
        byte[] data = new byte[length];
        int dataIndex = 0;
        int i = sliceId;
        while (length > 0) {
            ChannelBuffer s = this.slices[i];
            int adjustment = this.indices[i];
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, data, dataIndex, localLength);
            index += localLength;
            dataIndex += localLength;
            length -= localLength;
            ++i;
        }
        try {
            return new String(data, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charsetName);
        }
    }

    private int sliceId(int index) {
        int lastSliceId = this.lastSliceId;
        if (index >= this.indices[lastSliceId]) {
            if (index < this.indices[lastSliceId + 1]) {
                return lastSliceId;
            }
            for (int i = lastSliceId + 1; i < this.slices.length; ++i) {
                if (index >= this.indices[i + 1]) continue;
                this.lastSliceId = i;
                return i;
            }
        } else {
            for (int i = lastSliceId - 1; i >= 0; --i) {
                if (index < this.indices[i]) continue;
                this.lastSliceId = i;
                return i;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

