/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt52;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analysis
implements Comparable<Analysis> {
    private List<String> impossibleMatchHtmlList = new ArrayList<String>();
    private List<String> conflictingMatchHtmlList = new ArrayList<String>();
    private List<String> duplicatedMatchHtmlList = new ArrayList<String>();

    public void addImpossibleMatch(String htmlEntry) {
        this.impossibleMatchHtmlList.add(htmlEntry);
    }

    public void addConflictingMatch(String htmlEntry) {
        this.conflictingMatchHtmlList.add(htmlEntry);
    }

    public void addDuplicatedMatch(String htmlEntry) {
        this.duplicatedMatchHtmlList.add(htmlEntry);
    }

    public String toHtmlString() {
        StringBuilder htmlBuilder = new StringBuilder("<span>");
        boolean first = true;
        for (String htmlEntry : this.impossibleMatchHtmlList) {
            if (!first) {
                htmlBuilder.append(", ");
                first = false;
            }
            htmlBuilder.append(htmlEntry);
        }
        for (String htmlEntry : this.conflictingMatchHtmlList) {
            if (!first) {
                htmlBuilder.append(", ");
                first = false;
            }
            htmlBuilder.append(htmlEntry);
        }
        for (String htmlEntry : this.duplicatedMatchHtmlList) {
            if (!first) {
                htmlBuilder.append(", ");
                first = false;
            }
            htmlBuilder.append(htmlEntry);
        }
        htmlBuilder.append("</span>");
        return htmlBuilder.toString();
    }

    public int getWarningsSize() {
        return this.getImpossibleMatchesSize() + this.getConflictingMatchSize() + this.getDuplicatedMatchSize();
    }

    public int getImpossibleMatchesSize() {
        return this.impossibleMatchHtmlList.size();
    }

    public int getConflictingMatchSize() {
        return this.conflictingMatchHtmlList.size();
    }

    public int getDuplicatedMatchSize() {
        return this.duplicatedMatchHtmlList.size();
    }

    @Override
    public int compareTo(Analysis other) {
        return Integer.valueOf(this.getWarningsSize()).compareTo(other.getWarningsSize());
    }
}

