/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.constraint.AnalyzedCondition;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.EvaluatorHelper;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.compiler.ExecutableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMConditionEvaluatorJitter {
    public static ConditionEvaluator jit(ExecutableStatement executableStatement, ClassLoader classLoader) {
        return ASMConditionEvaluatorJitter.generateConditionEvaluator(new AnalyzedCondition(executableStatement), classLoader);
    }

    private static ConditionEvaluator generateConditionEvaluator(AnalyzedCondition analyzedCondition, ClassLoader classLoader) {
        ClassGenerator generator = new ClassGenerator(ASMConditionEvaluatorJitter.getUniqueClassName(), classLoader).setInterfaces(ConditionEvaluator.class).addDefaultConstructor();
        generator.addMethod(1, "evaluate", generator.methodDescr(Boolean.TYPE, Object.class), new EvaluateMethodGenerator(analyzedCondition));
        return (ConditionEvaluator)generator.newInstance();
    }

    private static String getUniqueClassName() {
        return "ConditionEvaluator" + StringUtils.generateUUID();
    }

    private static Class<?> findCommonClass(Class<?> class1, boolean primitive1, Class<?> class2, boolean primitive2) {
        if (class1 == class2) {
            return class1;
        }
        if (class1 == Object.class) {
            return class2;
        }
        if (class2 == Object.class) {
            return class1;
        }
        if (class1 == String.class) {
            return class2;
        }
        if (class2 == String.class) {
            return class1;
        }
        Class<?> result = ASMConditionEvaluatorJitter.findCommonClass(class1, class2, primitive2);
        if (result == null) {
            result = ASMConditionEvaluatorJitter.findCommonClass(class2, class1, primitive1);
        }
        if (result == null) {
            throw new RuntimeException("Cannot find a common class between " + class1.getName() + " and " + class2.getName());
        }
        return result;
    }

    private static Class<?> findCommonClass(Class<?> class1, Class<?> class2, boolean canBePrimitive) {
        if (class1.isAssignableFrom(class2)) {
            return class1;
        }
        if (class1 == Boolean.TYPE && class2 == Boolean.class) {
            return canBePrimitive ? Boolean.TYPE : Boolean.class;
        }
        if (class1 == Integer.TYPE || class1 == Short.TYPE || class1 == Byte.TYPE) {
            if (class2 == Integer.class) {
                return canBePrimitive ? Integer.TYPE : Integer.class;
            }
            if (class2 == Long.TYPE) {
                return Long.TYPE;
            }
            if (class2 == Long.class) {
                return canBePrimitive ? Long.TYPE : Long.class;
            }
            if (class2 == Float.TYPE) {
                return Float.TYPE;
            }
            if (class2 == Float.class) {
                return canBePrimitive ? Float.TYPE : Float.class;
            }
            if (class2 == Double.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Double.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigInteger.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Long.TYPE) {
            if (class2 == Integer.TYPE) {
                return Long.TYPE;
            }
            if (class2 == Integer.class) {
                return canBePrimitive ? Long.TYPE : Long.class;
            }
            if (class2 == Long.class) {
                return canBePrimitive ? Long.TYPE : Long.class;
            }
            if (class2 == Float.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Float.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == Double.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Double.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigInteger.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Float.TYPE) {
            if (class2 == Integer.TYPE) {
                return Float.TYPE;
            }
            if (class2 == Integer.class) {
                return canBePrimitive ? Float.TYPE : Float.class;
            }
            if (class2 == Long.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Long.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == Float.class) {
                return canBePrimitive ? Float.TYPE : Float.class;
            }
            if (class2 == Double.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Double.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigDecimal.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Double.TYPE) {
            if (class2 == Integer.TYPE) {
                return Float.TYPE;
            }
            if (class2 == Integer.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == Long.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Long.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == Float.TYPE) {
                return Double.TYPE;
            }
            if (class2 == Float.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == Double.class) {
                return canBePrimitive ? Double.TYPE : Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigDecimal.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Integer.class) {
            if (class2 == Long.class) {
                return Long.class;
            }
            if (class2 == Float.class) {
                return Float.class;
            }
            if (class2 == Double.class) {
                return Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigInteger.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Long.class) {
            if (class2 == Float.class) {
                return Double.class;
            }
            if (class2 == Double.class) {
                return Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigInteger.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Float.class) {
            if (class2 == Double.class) {
                return Double.class;
            }
            if (class2 == BigInteger.class) {
                return BigDecimal.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == Double.class) {
            if (class2 == BigInteger.class) {
                return BigDecimal.class;
            }
            if (class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
        }
        if (class1 == BigInteger.class && class2 == BigDecimal.class) {
            return BigDecimal.class;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvaluateMethodGenerator
    extends ClassGenerator.MethodBody {
        private AnalyzedCondition analyzedCondition;

        public EvaluateMethodGenerator(AnalyzedCondition analyzedCondition) {
            this.analyzedCondition = analyzedCondition;
        }

        @Override
        public void body(MethodVisitor mv) {
            if (this.analyzedCondition.isBinary()) {
                this.jitBinary(mv);
            } else {
                this.jitUnary(mv);
            }
            if (this.analyzedCondition.isNegated()) {
                this.jitNegation(mv);
            }
            mv.visitInsn(172);
        }

        private void jitUnary(MethodVisitor mv) {
            this.jitExpression(mv, this.analyzedCondition.getLeft());
        }

        private void jitBinary(MethodVisitor mv) {
            Class commonType;
            AnalyzedCondition.Expression left = this.analyzedCondition.getLeft();
            AnalyzedCondition.Expression right = this.analyzedCondition.getRight();
            Class clazz = this.analyzedCondition.getOperation().needsSameType() ? ASMConditionEvaluatorJitter.findCommonClass(left.getType(), !left.canBeNull(), right.getType(), !right.canBeNull()) : (commonType = null);
            if (commonType != null && commonType.isPrimitive()) {
                this.jitPrimitiveBinary(mv, left, right, commonType);
            } else {
                this.jitObjectBinary(mv, left, right, commonType);
            }
        }

        private void jitPrimitiveBinary(MethodVisitor mv, AnalyzedCondition.Expression left, AnalyzedCondition.Expression right, Class<?> type) {
            if (right.isFixed() && right.canBeNull()) {
                mv.visitInsn(this.analyzedCondition.getOperation() == AnalyzedCondition.BooleanOperator.NE ? 4 : 3);
                return;
            }
            this.jitTopExpression(mv, left, type);
            this.jitTopExpression(mv, right, type);
            this.jitPrimitiveOperation(mv, this.analyzedCondition.getOperation(), type);
        }

        private void jitObjectBinary(MethodVisitor mv, AnalyzedCondition.Expression left, AnalyzedCondition.Expression right, Class<?> type) {
            if (left.isFixed()) {
                throw new RuntimeException("Unmanaged fixed left");
            }
            Class<?> leftType = left.getType();
            Class<?> rightType = right.getType();
            this.jitTopExpression(mv, left, type != null ? type : leftType);
            this.store(2, leftType);
            this.jitTopExpression(mv, right, type != null ? type : rightType);
            this.store(4, rightType);
            Label notNullLabel = this.jitLeftIsNull(mv, type == null || leftType == type ? this.jitNullSafeOperationStart(mv) : this.jitNullSafeCoercion(mv, leftType, type));
            AnalyzedCondition.BooleanOperator operation = this.analyzedCondition.getOperation();
            if (operation.isEquality()) {
                this.checkNullEquality(mv, operation);
            } else {
                mv.visitInsn(3);
            }
            this.returnOnNull(mv, notNullLabel);
            this.loadOperands(mv, right, type, rightType);
            if (operation == AnalyzedCondition.BooleanOperator.CONTAINS) {
                this.invokeStatic(EvaluatorHelper.class, "contains", Boolean.TYPE, Object.class, Object.class);
            } else if (operation == AnalyzedCondition.BooleanOperator.MATCHES) {
                this.invokeVirtual(type, "matches", Boolean.TYPE, String.class);
            } else if (operation.isEquality()) {
                if (type.isInterface()) {
                    this.invokeInterface(type, "equals", Boolean.TYPE, Object.class);
                } else {
                    this.invokeVirtual(type, "equals", Boolean.TYPE, Object.class);
                }
                if (operation == AnalyzedCondition.BooleanOperator.NE) {
                    this.analyzedCondition.toggleNegation();
                }
            } else {
                if (type.isInterface()) {
                    this.invokeInterface(type, "compareTo", Integer.TYPE, type);
                } else {
                    this.invokeVirtual(type, "compareTo", Integer.TYPE, type);
                }
                mv.visitInsn(3);
                this.jitPrimitiveOperation(mv, operation, Integer.TYPE);
            }
        }

        private void returnOnNull(MethodVisitor mv, Label notNullLabel) {
            mv.visitInsn(172);
            mv.visitLabel(notNullLabel);
        }

        private void loadOperands(MethodVisitor mv, AnalyzedCondition.Expression right, Class<?> type, Class<?> rightType) {
            this.load(2);
            this.load(4);
            if (type != null && !right.isFixed() && rightType != type) {
                this.jitRightCoercion(mv, rightType, type);
            }
        }

        private void checkNullEquality(MethodVisitor mv, AnalyzedCondition.BooleanOperator operation) {
            Label rightNullLabel = new Label();
            Label rightNotNullLabel = new Label();
            this.load(4);
            mv.visitJumpInsn(198, rightNullLabel);
            mv.visitInsn(operation == AnalyzedCondition.BooleanOperator.EQ ? 3 : 4);
            mv.visitJumpInsn(167, rightNotNullLabel);
            mv.visitLabel(rightNullLabel);
            mv.visitInsn(operation == AnalyzedCondition.BooleanOperator.EQ ? 4 : 3);
            mv.visitLabel(rightNotNullLabel);
        }

        private Label jitNullSafeCoercion(MethodVisitor mv, Class<?> fromType, Class<?> toType) {
            Label nullLabel = new Label();
            this.load(2);
            mv.visitJumpInsn(198, nullLabel);
            mv.visitTypeInsn(187, this.internalName(toType));
            mv.visitInsn(89);
            this.load(2);
            this.invokeVirtual(fromType, "toString", String.class, new Class[0]);
            this.invokeSpecial(toType, "<init>", null, String.class);
            this.store(2, toType);
            return nullLabel;
        }

        private Label jitNullSafeOperationStart(MethodVisitor mv) {
            Label nullLabel = new Label();
            this.load(2);
            mv.visitJumpInsn(198, nullLabel);
            return nullLabel;
        }

        private void jitRightCoercion(MethodVisitor mv, Class<?> fromType, Class<?> toType) {
            this.store(4, fromType);
            mv.visitTypeInsn(187, this.internalName(toType));
            mv.visitInsn(89);
            this.load(4);
            this.invokeVirtual(fromType, "toString", String.class, new Class[0]);
            this.invokeSpecial(toType, "<init>", null, String.class);
        }

        private Label jitLeftIsNull(MethodVisitor mv, Label nullLabel) {
            Label notNullLabel = new Label();
            mv.visitJumpInsn(167, notNullLabel);
            mv.visitLabel(nullLabel);
            return notNullLabel;
        }

        private void jitTopExpression(MethodVisitor mv, AnalyzedCondition.Expression exp, Class<?> requiredClass) {
            if (exp.isFixed()) {
                this.push(((AnalyzedCondition.FixedExpression)exp).typedValue.value, requiredClass);
            } else {
                this.jitEvaluatedExpression(mv, (AnalyzedCondition.EvaluatedExpression)exp);
            }
        }

        private void jitExpression(MethodVisitor mv, AnalyzedCondition.Expression exp) {
            if (exp.isFixed()) {
                this.push(((AnalyzedCondition.FixedExpression)exp).typedValue.value, exp.getType());
            } else {
                this.jitEvaluatedExpression(mv, (AnalyzedCondition.EvaluatedExpression)exp);
            }
        }

        private void jitEvaluatedExpression(MethodVisitor mv, AnalyzedCondition.EvaluatedExpression exp) {
            Iterator<AnalyzedCondition.Invocation> invocations = exp.invocations.iterator();
            Class<?> currentClass = this.jitInvocation(mv, invocations.next(), Object.class, true);
            while (invocations.hasNext()) {
                currentClass = this.jitInvocation(mv, invocations.next(), currentClass, false);
            }
        }

        private Class<?> jitInvocation(MethodVisitor mv, AnalyzedCondition.Invocation invocation, Class<?> currentClass, boolean firstInvocation) {
            if (invocation instanceof AnalyzedCondition.MethodInvocation) {
                this.jitMethodInvocation(mv, (AnalyzedCondition.MethodInvocation)invocation, currentClass, firstInvocation);
            } else if (invocation instanceof AnalyzedCondition.ConstructorInvocation) {
                this.jitConstructorInvocation(mv, (AnalyzedCondition.ConstructorInvocation)invocation);
            } else if (invocation instanceof AnalyzedCondition.ListAccessInvocation) {
                this.jitListAccessInvocation(mv, (AnalyzedCondition.ListAccessInvocation)invocation);
            } else if (invocation instanceof AnalyzedCondition.MapAccessInvocation) {
                this.jitMapAccessInvocation(mv, (AnalyzedCondition.MapAccessInvocation)invocation);
            } else {
                this.jitFieldAccessInvocation(mv, (AnalyzedCondition.FieldAccessInvocation)invocation, currentClass, firstInvocation);
            }
            return invocation.getReturnType();
        }

        private void jitMethodInvocation(MethodVisitor mv, AnalyzedCondition.MethodInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            Method method = invocation.getMethod();
            if (firstInvocation && (method == null || (method.getModifiers() & 8) == 0)) {
                mv.visitVarInsn(25, 1);
            }
            if (method == null) {
                if (firstInvocation) {
                    return;
                }
                throw new RuntimeException("access to this not in first position");
            }
            if (!method.getDeclaringClass().isAssignableFrom(currentClass)) {
                this.cast(method.getDeclaringClass());
            }
            for (AnalyzedCondition.Expression argument : invocation.getArguments()) {
                this.jitExpression(mv, argument);
            }
            this.invoke(method);
        }

        private void jitConstructorInvocation(MethodVisitor mv, AnalyzedCondition.ConstructorInvocation invocation) {
            Constructor constructor = invocation.getConstructor();
            Class<?> clazz = invocation.getReturnType();
            mv.visitTypeInsn(187, this.internalName(clazz));
            mv.visitInsn(89);
            for (AnalyzedCondition.Expression argument : invocation.getArguments()) {
                this.jitExpression(mv, argument);
            }
            this.invokeSpecial(clazz, "<init>", null, constructor.getParameterTypes());
        }

        private void jitListAccessInvocation(MethodVisitor mv, AnalyzedCondition.ListAccessInvocation invocation) {
            this.jitTopExpression(mv, invocation.getIndex(), Integer.TYPE);
            this.invokeInterface(List.class, "get", Object.class, Integer.TYPE);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitMapAccessInvocation(MethodVisitor mv, AnalyzedCondition.MapAccessInvocation invocation) {
            this.jitTopExpression(mv, invocation.getKey(), invocation.getKeyType());
            this.invokeInterface(Map.class, "get", Object.class, Object.class);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitFieldAccessInvocation(MethodVisitor mv, AnalyzedCondition.FieldAccessInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            boolean isStatic;
            Field field = invocation.getField();
            boolean bl = isStatic = (field.getModifiers() & 8) != 0;
            if (firstInvocation && !isStatic) {
                mv.visitVarInsn(25, 1);
            }
            if (!isStatic && !field.getDeclaringClass().isAssignableFrom(currentClass)) {
                this.cast(field.getDeclaringClass());
            }
            this.readField(field);
        }

        private void jitPrimitiveOperation(MethodVisitor mv, AnalyzedCondition.BooleanOperator op, Class<?> type) {
            this.jitPrimitiveCompare(mv, EvaluateMethodGenerator.toOpCode(op, type), type);
        }

        private void jitPrimitiveCompare(MethodVisitor mv, int opCode, Class<?> type) {
            Label trueBranchLabel = new Label();
            Label returnLabel = new Label();
            if (type == Double.TYPE) {
                mv.visitInsn(151);
            } else if (type == Long.TYPE) {
                mv.visitInsn(148);
            } else if (type == Float.TYPE) {
                mv.visitInsn(149);
            }
            mv.visitJumpInsn(opCode, trueBranchLabel);
            mv.visitInsn(3);
            mv.visitJumpInsn(167, returnLabel);
            mv.visitLabel(trueBranchLabel);
            mv.visitInsn(4);
            mv.visitLabel(returnLabel);
        }

        private void jitNegation(MethodVisitor mv) {
            Label trueBranch = new Label();
            Label falseBranch = new Label();
            mv.visitJumpInsn(154, trueBranch);
            mv.visitInsn(4);
            mv.visitJumpInsn(167, falseBranch);
            mv.visitLabel(trueBranch);
            mv.visitInsn(3);
            mv.visitLabel(falseBranch);
        }

        private static int toOpCode(AnalyzedCondition.BooleanOperator op, Class<?> type) {
            if (type == Double.TYPE || type == Long.TYPE || type == Float.TYPE) {
                switch (op) {
                    case EQ: {
                        return 153;
                    }
                    case NE: {
                        return 154;
                    }
                    case GT: {
                        return 157;
                    }
                    case GE: {
                        return 156;
                    }
                    case LT: {
                        return 155;
                    }
                    case LE: {
                        return 158;
                    }
                }
            } else {
                switch (op) {
                    case EQ: {
                        return 159;
                    }
                    case NE: {
                        return 160;
                    }
                    case GT: {
                        return 163;
                    }
                    case GE: {
                        return 162;
                    }
                    case LT: {
                        return 161;
                    }
                    case LE: {
                        return 164;
                    }
                }
            }
            throw new RuntimeException("Unknown operation: " + (Object)((Object)op));
        }
    }
}

