/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.drools.runtime.Environment;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAProcessInstanceDbLog {
    private Environment env;
    private EntityManagerFactory emf;
    private EntityManager em;

    public JPAProcessInstanceDbLog() {
    }

    public JPAProcessInstanceDbLog(Environment env) {
        this.env = env;
    }

    public List<ProcessInstanceLog> findProcessInstances() {
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog").getResultList();
        return result;
    }

    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId).getResultList();
        return result;
    }

    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId).getResultList();
        return result;
    }

    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        ProcessInstanceLog result = (ProcessInstanceLog)this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
        return result;
    }

    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        return result;
    }

    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId).getResultList();
        return result;
    }

    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        List result = this.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        return result;
    }

    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        List result = this.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        return result;
    }

    public void clear() {
        try {
            UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            ut.begin();
            List processInstances = this.getEntityManager().createQuery("FROM ProcessInstanceLog").getResultList();
            for (ProcessInstanceLog processInstance : processInstances) {
                this.getEntityManager().remove((Object)processInstance);
            }
            List nodeInstances = this.getEntityManager().createQuery("FROM NodeInstanceLog").getResultList();
            for (NodeInstanceLog nodeInstance : nodeInstances) {
                this.getEntityManager().remove((Object)nodeInstance);
            }
            this.em.joinTransaction();
            ut.commit();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (RollbackException e) {
            e.printStackTrace();
        }
        catch (HeuristicMixedException e) {
            e.printStackTrace();
        }
        catch (HeuristicRollbackException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (NotSupportedException e) {
            e.printStackTrace();
        }
    }

    protected EntityManager getEntityManager() {
        if (this.em == null) {
            if (this.env == null) {
                if (this.emf == null) {
                    this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
                }
                this.em = this.emf.createEntityManager();
            } else {
                EntityManagerFactory emf = (EntityManagerFactory)this.env.get("drools.persistence.jpa.EntityManagerFactory");
                this.em = emf.createEntityManager();
            }
        }
        return this.em;
    }

    public void dispose() {
        if (this.em != null) {
            this.em.close();
            this.em = null;
        }
        if (this.emf != null) {
            this.emf.close();
        }
    }
}

