/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveVisitor
implements Visitor {
    protected static transient Logger logger = LoggerFactory.getLogger(ReflectiveVisitor.class);
    static final String newline = System.getProperty("line.separator");
    private Map<Class<?>, Method> methodCache = new HashMap();

    @Override
    public void visit(Object object) {
        Method method = null;
        try {
            if (object != null) {
                method = this.getMethod(object.getClass());
                method.invoke((Object)this, object);
            } else {
                method = this.getClass().getMethod("visitNull", null);
                method.invoke((Object)this, (Object[])null);
            }
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e.toString() + " : " + object, e);
        }
    }

    private Method getMethod(Class<?> clazz) {
        if (this.methodCacheContains(clazz)) {
            return this.getMethodFromCache(clazz);
        }
        Class<?> newClazz = clazz;
        Method method = null;
        while (method == null && newClazz != Object.class) {
            String methodName = newClazz.getName();
            methodName = "visit" + methodName.substring(methodName.lastIndexOf(46) + 1);
            try {
                method = this.getClass().getMethod(methodName, newClazz);
            }
            catch (NoSuchMethodException e) {
                newClazz = newClazz.getSuperclass();
            }
        }
        if (newClazz == Object.class) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length && method == null; ++i) {
                String methodName = interfaces[i].getName();
                methodName = "visit" + methodName.substring(methodName.lastIndexOf(46) + 1);
                try {
                    method = this.getClass().getMethod(methodName, interfaces[i]);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        if (method == null) {
            try {
                method = this.getClass().getMethod("visitObject", Object.class);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException(e.toString() + " : " + clazz, e.getCause());
            }
        }
        this.addMethodToCache(clazz, method);
        return method;
    }

    public void visitObject(Object object) {
        logger.error("no visitor implementation for : " + object.getClass() + " : " + object);
    }

    private void addMethodToCache(Class<?> clazz, Method m) {
        this.methodCache.put(clazz, m);
    }

    private Method getMethodFromCache(Class<?> clazz) {
        return this.methodCache.get(clazz);
    }

    private boolean methodCacheContains(Class<?> clazz) {
        return this.methodCache.containsKey(clazz);
    }
}

