/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.conf.IndexPrecedenceOption;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.LeftTupleIndexHashTable;
import org.drools.core.util.index.LeftTupleIndexRBTree;
import org.drools.core.util.index.LeftTupleIndexRangeRBTree;
import org.drools.core.util.index.LeftTupleList;
import org.drools.core.util.index.RightTupleIndexHashTable;
import org.drools.core.util.index.RightTupleIndexRBTree;
import org.drools.core.util.index.RightTupleIndexRangeRBTree;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;

public class IndexUtil {
    private static final boolean USE_COMPARISON_INDEX = true;
    private static final boolean USE_RANGE_INDEX = false;

    public static boolean compositeAllowed(BetaNodeFieldConstraint[] constraints, short betaNodeType) {
        int firstUnification = -1;
        int firstNonUnification = -1;
        int length = constraints.length;
        for (int i = 0; i < length; ++i) {
            if (IndexUtil.isIndexable(constraints[i], betaNodeType)) {
                boolean isUnification = ((IndexableConstraint)((Object)constraints[i])).isUnification();
                if (isUnification && firstUnification == -1) {
                    firstUnification = i;
                } else if (!isUnification && firstNonUnification == -1) {
                    firstNonUnification = i;
                }
            }
            if (firstUnification != -1 && firstNonUnification != -1) break;
        }
        if (firstNonUnification != -1 && firstNonUnification > 0) {
            IndexUtil.swap(constraints, 0, firstNonUnification);
        }
        return firstUnification == -1;
    }

    public static boolean isIndexable(BetaNodeFieldConstraint constraint, short nodeType) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).isIndexable(nodeType);
    }

    private static boolean canHaveRangeIndex(short nodeType) {
        return nodeType == 1 || nodeType == 2;
    }

    public static boolean isIndexableForNode(short nodeType, BetaNodeFieldConstraint constraint) {
        if (!(constraint instanceof IndexableConstraint)) {
            return false;
        }
        ConstraintType constraintType = ((IndexableConstraint)((Object)constraint)).getConstraintType();
        return constraintType.isIndexableForNode(nodeType);
    }

    public static boolean[] isIndexableForNode(IndexPrecedenceOption indexPrecedenceOption, short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints) {
        if (keyDepth < 1) {
            return new boolean[constraints.length];
        }
        return indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? IndexUtil.findIndexableWithEqualityPriority(nodeType, keyDepth, constraints) : IndexUtil.findIndexableWithPatternOrder(nodeType, keyDepth, constraints);
    }

    private static boolean[] findIndexableWithEqualityPriority(short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints) {
        boolean[] indexable = new boolean[constraints.length];
        if (IndexUtil.hasEqualIndexable(keyDepth, indexable, constraints)) {
            return indexable;
        }
        if (!IndexUtil.canHaveRangeIndex(nodeType)) {
            return indexable;
        }
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType)) continue;
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean[] findIndexableWithPatternOrder(short nodeType, int keyDepth, BetaNodeFieldConstraint[] constraints) {
        boolean[] indexable = new boolean[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            if (!IndexUtil.isIndexable(constraints[i], nodeType)) continue;
            if (IndexUtil.isEqualIndexable(constraints[i])) {
                IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, i);
                break;
            }
            IndexUtil.sortRangeIndexable(constraints, indexable, i);
            break;
        }
        return indexable;
    }

    private static boolean hasEqualIndexable(int keyDepth, boolean[] indexable, BetaNodeFieldConstraint[] constraints) {
        return IndexUtil.sortEqualIndexable(keyDepth, indexable, constraints, 0);
    }

    private static boolean sortEqualIndexable(int keyDepth, boolean[] indexable, BetaNodeFieldConstraint[] constraints, int start) {
        boolean hasEqualIndexable = false;
        int indexableCouter = 0;
        for (int i = start; i < constraints.length; ++i) {
            if (!IndexUtil.isEqualIndexable(constraints[i])) continue;
            hasEqualIndexable = true;
            if (keyDepth <= indexableCouter) continue;
            IndexUtil.swap(constraints, i, indexableCouter);
            indexable[indexableCouter++] = true;
        }
        return hasEqualIndexable;
    }

    private static void sortRangeIndexable(BetaNodeFieldConstraint[] constraints, boolean[] indexable, int i) {
        int dualConstraintPosition = IndexUtil.findDualConstraint(constraints, i);
        IndexUtil.swap(constraints, i, 0);
        indexable[0] = true;
        if (dualConstraintPosition > 0) {
            IndexUtil.swap(constraints, dualConstraintPosition, 1);
            indexable[1] = true;
        }
    }

    private static int findDualConstraint(BetaNodeFieldConstraint[] constraints, int comparisonPos) {
        return -1;
    }

    private static boolean isEqualIndexable(BetaNodeFieldConstraint constraint) {
        return constraint instanceof IndexableConstraint && ((IndexableConstraint)((Object)constraint)).getConstraintType() == ConstraintType.EQUAL;
    }

    private static void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        if (p1 != p2) {
            BetaNodeFieldConstraint temp = constraints[p2];
            constraints[p2] = constraints[p1];
            constraints[p1] = temp;
        }
    }

    private static boolean isDual(MvelConstraint firstConstraint, String leftValue, MvelConstraint dualConstraint) {
        return dualConstraint.getConstraintType().isComparison() && dualConstraint.getConstraintType().isAscending() != firstConstraint.getConstraintType().isAscending() && leftValue.equals(IndexUtil.getLeftValueInExpression(dualConstraint.getExpression()));
    }

    private static String getLeftValueInExpression(String expression) {
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '.') continue;
            return expression.substring(0, i);
        }
        return expression;
    }

    public static class Factory {
        public static BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType, BetaNodeFieldConstraint ... constraints) {
            int keyDepth = config.getCompositeKeyDepth();
            if (config.getCompositeKeyDepth() < 1) {
                return new BetaMemory(config.isSequential() ? null : new LeftTupleList(), new RightTupleList(), Factory.createContext(constraints), nodeType);
            }
            IndexSpec indexSpec = new IndexSpec(config.getIndexPrecedenceOption(), keyDepth, nodeType, constraints);
            return new BetaMemory(Factory.createLeftMemory(config, indexSpec), Factory.createRightMemory(config, indexSpec), Factory.createContext(constraints), nodeType);
        }

        private static RightTupleMemory createRightMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
            if (!config.isIndexRightBetaMemory() || !indexSpec.constraintType.isIndexable()) {
                return new RightTupleList();
            }
            if (indexSpec.constraintType == ConstraintType.EQUAL) {
                return new RightTupleIndexHashTable(indexSpec.indexes);
            }
            if (indexSpec.constraintType.isComparison()) {
                return new RightTupleIndexRBTree(indexSpec.constraintType, indexSpec.indexes[0]);
            }
            if (indexSpec.constraintType == ConstraintType.RANGE) {
                return new RightTupleIndexRangeRBTree(indexSpec.ascendingConstraintType, indexSpec.indexes[0], indexSpec.descendingConstraintType, indexSpec.indexes[1]);
            }
            return new RightTupleList();
        }

        private static LeftTupleMemory createLeftMemory(RuleBaseConfiguration config, IndexSpec indexSpec) {
            if (config.isSequential()) {
                return null;
            }
            if (!config.isIndexLeftBetaMemory() || !indexSpec.constraintType.isIndexable()) {
                return new LeftTupleList();
            }
            if (indexSpec.constraintType == ConstraintType.EQUAL) {
                return new LeftTupleIndexHashTable(indexSpec.indexes);
            }
            if (indexSpec.constraintType.isComparison()) {
                return new LeftTupleIndexRBTree(indexSpec.constraintType, indexSpec.indexes[0]);
            }
            if (indexSpec.constraintType == ConstraintType.RANGE) {
                return new LeftTupleIndexRangeRBTree(indexSpec.ascendingConstraintType, indexSpec.indexes[0], indexSpec.descendingConstraintType, indexSpec.indexes[1]);
            }
            return new LeftTupleList();
        }

        public static ContextEntry[] createContext(BetaNodeFieldConstraint ... constraints) {
            ContextEntry[] entries = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                entries[i] = constraints[i].createContextEntry();
            }
            return entries;
        }

        private static class IndexSpec {
            private ConstraintType constraintType = ConstraintType.UNKNOWN;
            private AbstractHashTable.FieldIndex[] indexes;
            private ConstraintType ascendingConstraintType = null;
            private ConstraintType descendingConstraintType = null;

            private IndexSpec(IndexPrecedenceOption indexPrecedenceOption, int keyDepth, short nodeType, BetaNodeFieldConstraint[] constraints) {
                this.init(indexPrecedenceOption, keyDepth, nodeType, constraints);
            }

            private void init(IndexPrecedenceOption indexPrecedenceOption, int keyDepth, short nodeType, BetaNodeFieldConstraint[] constraints) {
                int firstIndexableConstraint;
                int n = firstIndexableConstraint = indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? this.determineTypeWithEqualityPriority(nodeType, constraints) : this.determineTypeWithPatternOrder(nodeType, constraints);
                if (this.constraintType == ConstraintType.EQUAL) {
                    ArrayList<AbstractHashTable.FieldIndex> indexList = new ArrayList<AbstractHashTable.FieldIndex>();
                    indexList.add(((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex());
                    for (int i = firstIndexableConstraint + 1; i < constraints.length && indexList.size() < keyDepth; ++i) {
                        if (ConstraintType.getType(constraints[i]) != ConstraintType.EQUAL) continue;
                        indexList.add(((IndexableConstraint)((Object)constraints[i])).getFieldIndex());
                    }
                    this.indexes = indexList.toArray(new AbstractHashTable.FieldIndex[indexList.size()]);
                } else if (this.constraintType.isComparison()) {
                    this.indexes = new AbstractHashTable.FieldIndex[]{((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex()};
                }
            }

            private int determineTypeWithEqualityPriority(short nodeType, BetaNodeFieldConstraint[] constraints) {
                int indexedConstraintPos = 0;
                for (int i = 0; i < constraints.length; ++i) {
                    if (!(constraints[i] instanceof IndexableConstraint)) continue;
                    IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)constraints[i]);
                    ConstraintType type = indexableConstraint.getConstraintType();
                    if (type == ConstraintType.EQUAL) {
                        this.constraintType = type;
                        return i;
                    }
                    if (this.constraintType != ConstraintType.UNKNOWN || !type.isIndexableForNode(nodeType)) continue;
                    this.constraintType = type;
                    indexedConstraintPos = i;
                }
                return indexedConstraintPos;
            }

            private int determineTypeWithPatternOrder(short nodeType, BetaNodeFieldConstraint[] constraints) {
                for (int i = 0; i < constraints.length; ++i) {
                    ConstraintType type = ConstraintType.getType(constraints[i]);
                    if (!type.isIndexableForNode(nodeType)) continue;
                    this.constraintType = type;
                    return i;
                }
                return constraints.length;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstraintType {
        EQUAL(true),
        NOT_EQUAL(false),
        GREATER_THAN(true),
        GREATER_OR_EQUAL(true),
        LESS_THAN(true),
        LESS_OR_EQUAL(true),
        RANGE(true),
        UNKNOWN(false);

        private final boolean indexable;

        private ConstraintType(boolean indexable) {
            this.indexable = indexable;
        }

        public boolean isComparison() {
            return this.isAscending() || this.isDescending();
        }

        public boolean isAscending() {
            return this == GREATER_THAN || this == GREATER_OR_EQUAL;
        }

        public boolean isDescending() {
            return this == LESS_THAN || this == LESS_OR_EQUAL;
        }

        public boolean isIndexable() {
            return this.indexable;
        }

        public boolean isIndexableForNode(short nodeType) {
            switch (this) {
                case EQUAL: {
                    return true;
                }
                case NOT_EQUAL: 
                case UNKNOWN: {
                    return false;
                }
            }
            return IndexUtil.canHaveRangeIndex(nodeType);
        }

        public static ConstraintType decode(String operator) {
            if (operator.equals("==")) {
                return EQUAL;
            }
            if (operator.equals("!=")) {
                return NOT_EQUAL;
            }
            if (operator.equals(">")) {
                return GREATER_THAN;
            }
            if (operator.equals(">=")) {
                return GREATER_OR_EQUAL;
            }
            if (operator.equals("<")) {
                return LESS_THAN;
            }
            if (operator.equals("<=")) {
                return LESS_OR_EQUAL;
            }
            return UNKNOWN;
        }

        public static ConstraintType getType(Constraint constraint) {
            return constraint instanceof IndexableConstraint ? ((IndexableConstraint)constraint).getConstraintType() : UNKNOWN;
        }
    }
}

