/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.iwork.KeynoteContentHandler;
import org.apache.tika.parser.iwork.NumbersContentHandler;
import org.apache.tika.parser.iwork.PagesContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWorkParser
implements Parser {
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.apple.keynote"), MediaType.application((String)"vnd.apple.pages"), MediaType.application((String)"vnd.apple.numbers"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        DefaultHandler contentHandler;
        String contentType = metadata.get("Content-Type");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        if ("application/vnd.apple.keynote".equals(contentType)) {
            contentHandler = new KeynoteContentHandler(xhtml, metadata);
        } else if ("application/vnd.apple.pages".equals(contentType)) {
            contentHandler = new PagesContentHandler(xhtml, metadata);
        } else if ("application/vnd.apple.numbers".equals(contentType)) {
            contentHandler = new NumbersContentHandler(xhtml, metadata);
        } else {
            return;
        }
        xhtml.startDocument();
        context.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)contentHandler));
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

