/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;

public final class ScoreNode {
    private final NodeId id;
    private float score;
    private final int doc;

    public ScoreNode(NodeId id, float score) {
        this(id, score, -1);
    }

    public ScoreNode(NodeId id, float score, int doc) {
        this.id = id;
        this.score = score;
        this.doc = doc;
    }

    public NodeId getNodeId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public int getDoc(IndexReader reader) throws IOException {
        if (this.doc == -1) {
            TermDocs docs = reader.termDocs(TermFactory.createUUIDTerm(this.id.toString()));
            try {
                if (docs.next()) {
                    int n = docs.doc();
                    return n;
                }
                throw new IOException("Node with id " + this.id + " not found in index");
            }
            finally {
                docs.close();
            }
        }
        return this.doc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.id.toString());
        sb.append("(");
        if (this.doc != -1) {
            sb.append(this.doc);
        } else {
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }
}

