/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;

public class AncestorPathNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap contextIndex = new ScoreNodeMap();
    private final HierarchyManager hmgr;
    private final Path relPath;

    public AncestorPathNodeJoin(MultiColumnQueryHits context, Name contextSelectorName, Path relPath, HierarchyManager hmgr) throws IOException {
        super(context);
        ScoreNode[] nodes;
        this.hmgr = hmgr;
        this.relPath = relPath;
        int idx = AncestorPathNodeJoin.getIndex(context, contextSelectorName);
        while ((nodes = context.nextScoreNodes()) != null) {
            try {
                Path p = hmgr.getPath(nodes[idx].getNodeId());
                this.contextIndex.addScoreNodes(p, nodes);
            }
            catch (RepositoryException e) {}
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode ancestor) throws IOException {
        try {
            Path ancestorPath = this.hmgr.getPath(ancestor.getNodeId());
            PathBuilder builder = new PathBuilder(ancestorPath);
            builder.addAll(this.relPath.getElements());
            return this.contextIndex.getScoreNodes(builder.getPath().getNormalizedPath());
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

