/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.GuvnorConnectionEditPage;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.WizardUtils;

public class EditRepLocationWizard
extends Wizard
implements INewWizard,
IGuvnorWizard {
    private GuvnorConnectionEditPage mainPage;
    private GuvnorRepository rep;
    private GuvWizardModel model = new GuvWizardModel();

    public EditRepLocationWizard(GuvnorRepository rep) {
        this.rep = rep;
    }

    public GuvWizardModel getModel() {
        return this.model;
    }

    public void addPages() {
        this.mainPage = new GuvnorConnectionEditPage(this.rep, "config_page", Messages.getString("edit.guvnor.loc"), Activator.getImageDescriptor("guvnor_rep_add.gif"));
        this.mainPage.setDescription(Messages.getString("edit.guvnor.loc.desc"));
        super.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    public boolean performFinish() {
        if (!this.model.getRepLocation().equals(this.rep.getLocation())) {
            try {
                WizardUtils.createGuvnorRepository(this.model);
            }
            catch (Exception e) {
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
                return false;
            }
            Activator.getLocationManager().removeRepository(this.rep.getLocation());
        } else {
            Activator.getLocationManager().removeRepository(this.rep.getLocation());
            try {
                WizardUtils.createGuvnorRepository(this.model);
            }
            catch (Exception e) {
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

