/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.DroolsParserException;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DescrUtil;
import org.drools.eclipse.editors.DroolsLineBreakpointAdapter;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLRuleEditor
extends AbstractRuleEditor {
    protected List<String> imports;
    protected List<String> functions;
    protected List<GlobalDescr> globals;
    protected String packageName;
    protected List<String> classesInPackage;
    protected Map<String, String> attributes;

    public List<String> getImports() {
        if (this.imports == null || this.isDirty()) {
            this.loadImportsAndFunctions();
        }
        return this.imports;
    }

    public List<String> getFunctions() {
        if (this.functions == null) {
            this.loadImportsAndFunctions();
        }
        return this.functions;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.loadImportsAndFunctions();
        }
        return this.attributes;
    }

    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadImportsAndFunctions();
        }
        return this.globals;
    }

    public String getPackage() {
        if (this.packageName == null) {
            this.loadImportsAndFunctions();
        }
        return this.packageName;
    }

    public List<String> getClassesInPackage() {
        if (this.classesInPackage == null) {
            this.classesInPackage = this.getAllClassesInPackage(this.getPackage());
        }
        return this.classesInPackage;
    }

    protected List<String> getAllClassesInPackage(String packageName) {
        IEditorInput input;
        List<String> list = new ArrayList<String>();
        if (packageName != null && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            list = DRLRuleEditor.getAllClassesInPackage(packageName, javaProject);
        }
        return list;
    }

    public static List<String> getAllClassesInPackage(String packageName, IJavaProject javaProject) {
        final ArrayList<String> list = new ArrayList<String>();
        CompletionRequestor requestor = new CompletionRequestor(){

            public void accept(CompletionProposal proposal) {
                String className = new String(proposal.getCompletion());
                if (proposal.getKind() == 9) {
                    list.add(className);
                }
            }
        };
        try {
            javaProject.newEvaluationContext().codeComplete(String.valueOf(packageName) + ".", packageName.length() + 1, requestor);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
        }
        return list;
    }

    protected List<String> getAllStaticMethodsInClass(String className) {
        IEditorInput input;
        final ArrayList<String> list = new ArrayList<String>();
        if (className != null && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            CompletionRequestor requestor = new CompletionRequestor(){

                public void accept(CompletionProposal proposal) {
                    String functionName = new String(proposal.getCompletion());
                    if (proposal.getKind() == 6) {
                        list.add(functionName.substring(0, functionName.length() - 2));
                    }
                }
            };
            try {
                javaProject.newEvaluationContext().codeComplete(String.valueOf(className) + ".", className.length() + 1, requestor);
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
            }
        }
        return list;
    }

    protected void loadImportsAndFunctions() {
        try {
            DRLInfo drlInfo = DroolsEclipsePlugin.getDefault().parseResource(this, true, false);
            PackageDescr descr = drlInfo.getPackageDescr();
            this.packageName = drlInfo.getPackageName();
            List allImports = descr.getImports();
            this.imports = new ArrayList<String>();
            if (this.packageName != null) {
                this.imports.addAll(this.getAllClassesInPackage(this.packageName));
            }
            Iterator iterator = allImports.iterator();
            while (iterator.hasNext()) {
                String importName = ((ImportDescr)iterator.next()).getTarget();
                if (importName.endsWith(".*")) {
                    String packageName = importName.substring(0, importName.length() - 2);
                    this.imports.addAll(this.getAllClassesInPackage(packageName));
                    continue;
                }
                this.imports.add(importName);
            }
            List functionDescrs = descr.getFunctions();
            List functionImports = descr.getFunctionImports();
            this.functions = new ArrayList<String>(functionDescrs.size());
            Iterator iterator2 = functionDescrs.iterator();
            while (iterator2.hasNext()) {
                this.functions.add(((FunctionDescr)iterator2.next()).getName());
            }
            Iterator iterator3 = functionImports.iterator();
            while (iterator3.hasNext()) {
                String functionImport = ((FunctionImportDescr)iterator3.next()).getTarget();
                if (functionImport.endsWith(".*")) {
                    String className = functionImport.substring(0, functionImport.length() - 2);
                    this.functions.addAll(this.getAllStaticMethodsInClass(className));
                    continue;
                }
                int index = functionImport.lastIndexOf(46);
                if (index == -1) continue;
                this.functions.add(functionImport.substring(index + 1));
            }
            List globalDescrs = descr.getGlobals();
            this.globals = new ArrayList<GlobalDescr>();
            Iterator iterator5 = globalDescrs.iterator();
            while (iterator5.hasNext()) {
                this.globals.add((GlobalDescr)iterator5.next());
            }
            this.attributes = new HashMap<String, String>();
            for (AttributeDescr attribute : descr.getAttributes()) {
                if (attribute == null || attribute.getName() == null) continue;
                this.attributes.put(attribute.getName(), attribute.getValue());
            }
        }
        catch (DroolsParserException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(IToggleBreakpointsTarget.class)) {
            return this.getBreakpointAdapter();
        }
        return super.getAdapter(adapter);
    }

    private Object getBreakpointAdapter() {
        return new DroolsLineBreakpointAdapter();
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.imports = null;
        this.functions = null;
        this.globals = null;
        this.packageName = null;
        this.classesInPackage = null;
    }

    public void gotoMarker(IMarker marker) {
        try {
            if (marker.getType().equals("org.drools.eclipse.droolsBreakpointMarker")) {
                int line = marker.getAttribute("Drools_DRL_LineNumber", -1);
                if (line > -1) {
                    --line;
                }
                try {
                    IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    this.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
                }
                catch (BadLocationException exc) {
                    DroolsEclipsePlugin.log(exc);
                }
            } else {
                super.gotoMarker(marker);
            }
        }
        catch (CoreException exc) {
            DroolsEclipsePlugin.log(exc);
        }
    }

    public BaseDescr getDescr(int offset) {
        try {
            DRLInfo info = DroolsEclipsePlugin.getDefault().parseResource(this, true, false);
            return DescrUtil.getDescr((BaseDescr)info.getPackageDescr(), offset);
        }
        catch (DroolsParserException droolsParserException) {
            return null;
        }
    }
}

