/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DroolsProjectPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.drools.eclipse.preferences.DroolsRuntimesPreferencePage";
    public static final String PROP_ID = "org.drools.eclipse.preferences.DroolsProjectPreferencePage";
    private Combo droolsRuntimeCombo;

    public DroolsProjectPreferencePage() {
        this.setTitle("Drools Project Preferences");
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Drools Runtime: ");
        this.droolsRuntimeCombo = new Combo(composite, 16384);
        DroolsRuntime[] runtimes = DroolsRuntimeManager.getDroolsRuntimes();
        int selection = -1;
        String currentRuntime = DroolsRuntimeManager.getDroolsRuntime(this.getProject());
        int i = 0;
        while (i < runtimes.length) {
            this.droolsRuntimeCombo.add(runtimes[i].getName());
            if (runtimes[i].getName().equals(currentRuntime)) {
                selection = i;
            }
            ++i;
        }
        if (selection != -1) {
            this.droolsRuntimeCombo.select(selection);
        } else if (runtimes.length > 0) {
            this.droolsRuntimeCombo.select(0);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.droolsRuntimeCombo.setLayoutData((Object)gridData);
        return composite;
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return project.getFile(".settings/.drools.runtime").exists();
    }

    public boolean performOk() {
        try {
            IFile file = this.getProject().getFile(".settings/.drools.runtime");
            if (this.useProjectSettings()) {
                String runtime = "<runtime>" + this.droolsRuntimeCombo.getItem(this.droolsRuntimeCombo.getSelectionIndex()) + "</runtime>";
                if (!file.exists()) {
                    IFolder folder = this.getProject().getFolder(".settings");
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    file.create((InputStream)new ByteArrayInputStream(runtime.getBytes()), true, null);
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(runtime.getBytes()), true, false, null);
                }
            } else if (file.exists()) {
                file.delete(true, null);
            }
            this.getProject().close(null);
            this.getProject().open(null);
        }
        catch (Throwable t) {
            DroolsEclipsePlugin.log(t);
            return false;
        }
        return super.performOk();
    }
}

