/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import org.jbpm.task.Escalation;
import org.jbpm.task.I18NText;
import org.jbpm.task.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@SequenceGenerator(name="deadlineIdSeq", sequenceName="DEADLINE_ID_SEQ", allocationSize=1)
public class Deadline
implements Externalizable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="deadlineIdSeq")
    private long id;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Deadline_Documentation_Id", nullable=true)
    private List<I18NText> documentation = Collections.emptyList();
    @Column(name="deadline_date")
    private Date date;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="Deadline_Escalation_Id", nullable=true)
    private List<Escalation> escalations = Collections.emptyList();
    @Basic
    private Short escalated = 0;

    public Boolean isEscalated() {
        if (this.escalated == null) {
            return null;
        }
        return this.escalated == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setEscalated(Boolean escalated) {
        this.escalated = escalated == null ? null : (escalated == true ? new Short("1") : new Short("0"));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.date != null) {
            out.writeBoolean(true);
            out.writeLong(this.date.getTime());
        } else {
            out.writeBoolean(false);
        }
        CollectionUtils.writeI18NTextList(this.documentation, out);
        CollectionUtils.writeEscalationList(this.escalations, out);
        out.writeShort(this.escalated.shortValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        if (in.readBoolean()) {
            this.date = new Date(in.readLong());
        }
        this.documentation = CollectionUtils.readI18NTextList(in);
        this.escalations = CollectionUtils.readEscalationList(in);
        this.escalated = in.readShort();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<I18NText> getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(List<I18NText> documentation) {
        this.documentation = documentation;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<Escalation> getEscalations() {
        return this.escalations;
    }

    public void setEscalations(List<Escalation> escalations) {
        this.escalations = escalations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + CollectionUtils.hashCode(this.documentation);
        result = 31 * result + CollectionUtils.hashCode(this.escalations);
        result = 31 * result + (this.isEscalated() != false ? 1231 : 1237);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deadline)) {
            return false;
        }
        Deadline other = (Deadline)obj;
        if (this.date == null ? other.date != null : this.date.getTime() != other.date.getTime()) {
            return false;
        }
        if (this.isEscalated() != other.isEscalated()) {
            return false;
        }
        return CollectionUtils.equals(this.documentation, other.documentation) && CollectionUtils.equals(this.escalations, other.escalations);
    }
}

