/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.factorial;

import java.math.BigInteger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class FactorialClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(FactorialClientHandler.class.getName());
    private int i = 1;
    private int receivedMessages = 0;
    private final int count;
    final BlockingQueue<BigInteger> answer = new LinkedBlockingQueue<BigInteger>();

    public FactorialClientHandler(int count) {
        this.count = count;
    }

    public BigInteger getFactorial() {
        boolean interrupted = false;
        while (true) {
            try {
                BigInteger factorial = this.answer.take();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return factorial;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.sendNumbers(e);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.sendNumbers(e);
    }

    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent e) {
        ++this.receivedMessages;
        if (this.receivedMessages == this.count) {
            e.getChannel().close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    boolean offered = FactorialClientHandler.this.answer.offer((BigInteger)e.getMessage());
                    assert (offered);
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    private void sendNumbers(ChannelStateEvent e) {
        Channel channel = e.getChannel();
        while (channel.isWritable() && this.i <= this.count) {
            channel.write(this.i);
            ++this.i;
        }
    }
}

