/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.TaggedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeParser
implements Parser {
    private static final long serialVersionUID = 2192845797749627824L;
    private MediaTypeRegistry registry;
    private List<Parser> parsers;
    private Parser fallback = new EmptyParser();

    public CompositeParser(MediaTypeRegistry registry, List<Parser> parsers) {
        this.parsers = parsers;
        this.registry = registry;
    }

    public CompositeParser(MediaTypeRegistry registry, Parser ... parsers) {
        this(registry, Arrays.asList(parsers));
    }

    public CompositeParser() {
        this(new MediaTypeRegistry(), new Parser[0]);
    }

    public Map<MediaType, Parser> getParsers(ParseContext context) {
        HashMap<MediaType, Parser> map = new HashMap<MediaType, Parser>();
        for (Parser parser : this.parsers) {
            for (MediaType type : parser.getSupportedTypes(context)) {
                map.put(type, parser);
            }
        }
        return map;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.registry;
    }

    public void setMediaTypeRegistry(MediaTypeRegistry registry) {
        this.registry = registry;
    }

    public Map<MediaType, Parser> getParsers() {
        return this.getParsers(new ParseContext());
    }

    public void setParsers(Map<MediaType, Parser> parsers) {
        this.parsers = new ArrayList<Parser>(parsers.size());
        for (Map.Entry<MediaType, Parser> entry : parsers.entrySet()) {
            this.parsers.add(ParserDecorator.withTypes(entry.getValue(), Collections.singleton(entry.getKey())));
        }
    }

    public Parser getFallback() {
        return this.fallback;
    }

    public void setFallback(Parser fallback) {
        this.fallback = fallback;
    }

    protected Parser getParser(Metadata metadata) {
        return this.getParser(metadata, new ParseContext());
    }

    protected Parser getParser(Metadata metadata, ParseContext context) {
        Map<MediaType, Parser> map = this.getParsers(context);
        MediaType type = MediaType.parse(metadata.get("Content-Type"));
        while (type != null) {
            Parser parser = map.get(type);
            if (parser != null) {
                return parser;
            }
            type = this.registry.getSupertype(type);
        }
        return this.fallback;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.getParsers(context).keySet();
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Parser parser = this.getParser(metadata);
        TaggedInputStream taggedStream = new TaggedInputStream(stream);
        TaggedContentHandler taggedHandler = new TaggedContentHandler(handler);
        try {
            parser.parse(taggedStream, taggedHandler, metadata, context);
        }
        catch (RuntimeException e) {
            throw new TikaException("Unexpected RuntimeException from " + parser, e);
        }
        catch (IOException e) {
            taggedStream.throwIfCauseOf(e);
            throw new TikaException("TIKA-198: Illegal IOException from " + parser, e);
        }
        catch (SAXException e) {
            taggedHandler.throwIfCauseOf(e);
            throw new TikaException("TIKA-237: Illegal SAXException from " + parser, e);
        }
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

