/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.exception.TikaException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseContext
implements Serializable {
    private static final long serialVersionUID = -5921436862145826534L;
    private final Map<Class<?>, Object> context = new HashMap();

    public <T> void set(Class<T> key, T value) {
        this.context.put(key, value);
    }

    public <T> T get(Class<T> key) {
        return (T)this.context.get(key);
    }

    public <T> T get(Class<T> key, T defaultValue) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public SAXParser getSAXParser() throws TikaException {
        SAXParser parser = this.get(SAXParser.class);
        if (parser != null) {
            return parser;
        }
        try {
            return this.getSAXParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to configure a SAX parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create a SAX parser", e);
        }
    }

    public SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = this.get(SAXParserFactory.class);
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        return factory;
    }
}

