/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl.templates;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldList;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class RuleModelPeerVariableVisitor {
    private final RuleModel model;
    private final String baseVariableName;
    private final List<ValueHolder> peerVariables = new ArrayList<ValueHolder>();

    public RuleModelPeerVariableVisitor(RuleModel model, String baseVariableName) {
        this.model = model;
        this.baseVariableName = baseVariableName;
    }

    public List<ValueHolder> getPeerVariables() {
        this.visit(this.model);
        return this.peerVariables;
    }

    private void visit(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof RuleModel) {
            this.visitRuleModel((RuleModel)o);
        } else if (o instanceof FactPattern) {
            this.visitFactPattern((FactPattern)o);
        } else if (o instanceof CompositeFieldConstraint) {
            this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
        } else if (o instanceof SingleFieldConstraintEBLeftSide) {
            this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
        } else if (o instanceof SingleFieldConstraint) {
            this.visitSingleFieldConstraint((SingleFieldConstraint)o);
        } else if (o instanceof CompositeFactPattern) {
            this.visitCompositeFactPattern((CompositeFactPattern)o);
        } else if (o instanceof FromAccumulateCompositeFactPattern) {
            this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
        } else if (o instanceof FromCollectCompositeFactPattern) {
            this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
        } else if (o instanceof FromCompositeFactPattern) {
            this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
        } else if (o instanceof ActionFieldList) {
            this.visitActionFieldList((ActionFieldList)o);
        }
    }

    private void visitRuleModel(RuleModel rm) {
        for (IPattern p : rm.lhs) {
            this.visit(p);
        }
        for (IAction a : rm.rhs) {
            this.visit(a);
        }
    }

    private void visitFactPattern(FactPattern fp) {
        if (this.isParentFactPattern(fp)) {
            for (FieldConstraint fc : fp.getFieldConstraints()) {
                this.visit(fc);
            }
        }
    }

    private boolean isParentFactPattern(FactPattern fp) {
        for (FieldConstraint fc : fp.getFieldConstraints()) {
            if (!this.isParentFactPattern(fc)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentFactPattern(FieldConstraint fc) {
        if (fc instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)fc;
            return this.isParentFactPattern(sfc);
        }
        if (fc instanceof CompositeFieldConstraint) {
            CompositeFieldConstraint cfc = (CompositeFieldConstraint)fc;
            return this.isParentFactPattern(cfc);
        }
        return false;
    }

    private boolean isParentFactPattern(SingleFieldConstraint sfc) {
        return sfc.getConstraintValueType() == 7 && sfc.getValue().equals(this.baseVariableName);
    }

    private boolean isParentFactPattern(CompositeFieldConstraint cfc) {
        if (cfc.compositeJunctionType.equals("&&")) {
            for (FieldConstraint fc : cfc.constraints) {
                if (!this.isParentFactPattern(fc)) continue;
                return true;
            }
        }
        return false;
    }

    private void visitCompositeFactPattern(CompositeFactPattern cfp) {
        for (IFactPattern p : cfp.getPatterns()) {
            this.visit(p);
        }
    }

    private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
        for (FieldConstraint fc : cfc.constraints) {
            this.visit(fc);
        }
    }

    private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
        if (pattern.factPattern != null) {
            this.visit(pattern.factPattern);
        }
    }

    private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
        if (pattern.factPattern != null) {
            this.visit(pattern.factPattern);
        }
    }

    private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
        if (pattern.factPattern != null) {
            this.visit(pattern.factPattern);
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
        if (sfc.getConstraintValueType() == 7) {
            this.peerVariables.add(new ValueHolder(sfc.getFieldName(), sfc.getValue(), ValueHolder.Type.TEMPLATE_KEY));
        } else {
            this.peerVariables.add(new ValueHolder(sfc.getFieldName(), sfc.getValue(), ValueHolder.Type.VALUE));
        }
    }

    private void visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
        if (sfexp.getConstraintValueType() == 7) {
            this.peerVariables.add(new ValueHolder(sfexp.getFieldName(), sfexp.getValue(), ValueHolder.Type.TEMPLATE_KEY));
        } else {
            this.peerVariables.add(new ValueHolder(sfexp.getFieldName(), sfexp.getValue(), ValueHolder.Type.VALUE));
        }
    }

    private void visitActionFieldList(ActionFieldList afl) {
        boolean addVariables = false;
        ArrayList<ValueHolder> variables = new ArrayList<ValueHolder>();
        for (ActionFieldValue afv : afl.fieldValues) {
            ValueHolder vh;
            if (afv.nature == 7L) {
                if (afv.getValue().equals(this.baseVariableName)) {
                    addVariables = true;
                }
                vh = new ValueHolder(afv.getField(), afv.getValue(), ValueHolder.Type.TEMPLATE_KEY);
                variables.add(vh);
                continue;
            }
            vh = new ValueHolder(afv.getField(), afv.getValue(), ValueHolder.Type.VALUE);
            variables.add(vh);
        }
        if (addVariables) {
            this.peerVariables.addAll(variables);
        }
    }

    public static class ValueHolder {
        private final String fieldName;
        private final String value;
        private final Type type;

        ValueHolder(String fieldName, String value, Type type) {
            this.fieldName = fieldName;
            this.value = value;
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            VALUE,
            TEMPLATE_KEY;

        }
    }
}

