/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.server.util.GuidedDTDRLUtilities;
import org.drools.ide.common.server.util.TemplateDataProvider;

public class GuidedDTTemplateDataProvider
implements TemplateDataProvider {
    private Map<String, DTCellValue52> templateKeysToValueMap = new HashMap<String, DTCellValue52>();

    public GuidedDTTemplateDataProvider(List<BaseColumn> columns, List<DTCellValue52> rowData) {
        if (columns == null) {
            throw new NullPointerException("columns cannot be null");
        }
        if (rowData == null) {
            throw new NullPointerException("rowData cannot be null");
        }
        if (rowData.size() != columns.size() - 1) {
            throw new IllegalArgumentException("rowData contains a different number of columns to those provided");
        }
        for (int index = 0; index < columns.size(); ++index) {
            BaseColumn column = columns.get(index);
            if (column instanceof BRLConditionVariableColumn) {
                BRLConditionVariableColumn brlCondition = (BRLConditionVariableColumn)column;
                this.templateKeysToValueMap.put(brlCondition.getVarName(), rowData.get(index));
                continue;
            }
            if (!(column instanceof BRLActionVariableColumn)) continue;
            BRLActionVariableColumn brlAction = (BRLActionVariableColumn)column;
            this.templateKeysToValueMap.put(brlAction.getVarName(), rowData.get(index));
        }
    }

    @Override
    public String getTemplateKeyValue(String key) {
        if (this.templateKeysToValueMap.containsKey(key)) {
            return this.getStringValue(this.templateKeysToValueMap.get(key));
        }
        return "";
    }

    private String getStringValue(DTCellValue52 cell) {
        if (!cell.hasValue()) {
            return "";
        }
        return GuidedDTDRLUtilities.convertDTCellValueToString(cell);
    }
}

