/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.kproject.KBase;
import org.drools.kproject.KBaseImpl;
import org.drools.kproject.KProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KProjectImpl
implements KProject {
    private String namespace;
    private String name;
    private String kProjectPath;
    private String kBasesPath;
    private Map<String, KBase> kBases = Collections.emptyMap();
    private transient PropertyChangeListener listener;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public PropertyChangeListener getListener() {
        return this.listener;
    }

    @Override
    public KProject setListener(PropertyChangeListener listener) {
        this.listener = listener;
        for (KBase kbase : this.kBases.values()) {
            kbase.setListener(listener);
        }
        return this;
    }

    @Override
    public String getKProjectPath() {
        return this.kProjectPath;
    }

    @Override
    public KProject setKProjectPath(String kprojectPath) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "kProjectPath", this.kProjectPath, this.kProjectPath));
        }
        this.kProjectPath = kprojectPath;
        return this;
    }

    @Override
    public String getKBasesPath() {
        return this.kBasesPath;
    }

    @Override
    public KProject setKBasesPath(String kprojectPath) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "kBasesPath", this.kBasesPath, this.kBasesPath));
        }
        this.kBasesPath = kprojectPath;
        return this;
    }

    @Override
    public KBase newKBase(String namespace, String name) {
        KBaseImpl kbase = new KBaseImpl(this, namespace, name);
        HashMap<String, KBase> newMap = new HashMap<String, KBase>();
        newMap.putAll(this.kBases);
        newMap.put(kbase.getQName(), kbase);
        this.setKBases(newMap);
        return kbase;
    }

    @Override
    public void removeKBase(String qName) {
        HashMap<String, KBase> newMap = new HashMap<String, KBase>();
        newMap.putAll(this.kBases);
        newMap.remove(qName);
        this.setKBases(newMap);
    }

    public void moveKBase(String oldQName, String newQName) {
        HashMap<String, KBase> newMap = new HashMap<String, KBase>();
        newMap.putAll(this.kBases);
        KBase kBase = (KBase)newMap.remove(oldQName);
        newMap.put(newQName, kBase);
        this.setKBases(newMap);
    }

    @Override
    public Map<String, KBase> getKBases() {
        return Collections.unmodifiableMap(this.kBases);
    }

    private void setKBases(Map<String, KBase> kBases) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "kBases", this.kBases, kBases));
            for (KBase kbase : kBases.values()) {
                kbase.setListener(this.listener);
            }
        }
        this.kBases = kBases;
    }

    List<String> validate() {
        ArrayList<String> problems = new ArrayList<String>();
        if (this.kProjectPath == null) {
            problems.add("A path to the kproject.properties file must be specified");
        }
        return problems;
    }

    public String toString() {
        return "KProject [kprojectPath=" + this.kProjectPath + ", kbases=" + this.kBases + "]";
    }
}

