/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientConsumerInternal;
import org.hornetq.core.client.impl.ClientMessageInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.message.impl.MessageImpl;

public class ClientMessageImpl
extends MessageImpl
implements ClientMessageInternal {
    private static final Logger log = Logger.getLogger(ClientMessageImpl.class);
    public static final SimpleString REPLYTO_HEADER_NAME = new SimpleString("JMSReplyTo");
    private int deliveryCount;
    private ClientConsumerInternal consumer;
    private int flowControlSize = -1;
    private InputStream bodyInputStream;

    public ClientMessageImpl() {
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        super(type, durable, expiration, timestamp, priority, initialMessageBufferSize);
    }

    @Override
    public boolean isServerMessage() {
        return false;
    }

    @Override
    public void onReceipt(ClientConsumerInternal consumer) {
        this.consumer = consumer;
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public void acknowledge() throws HornetQException {
        if (this.consumer != null) {
            this.consumer.acknowledge(this);
        }
    }

    @Override
    public int getFlowControlSize() {
        if (this.flowControlSize < 0) {
            throw new IllegalStateException("Flow Control hasn't been set");
        }
        return this.flowControlSize;
    }

    @Override
    public void setFlowControlSize(int flowControlSize) {
        this.flowControlSize = flowControlSize;
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return this.properties.getBooleanProperty(Message.HDR_LARGE_COMPRESSED);
    }

    @Override
    public int getBodySize() {
        return this.buffer.writerIndex() - this.buffer.readerIndex();
    }

    public String toString() {
        return "ClientMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]";
    }

    @Override
    public void saveToOutputStream(OutputStream out) throws HornetQException {
        try {
            byte[] readBuffer = new byte[this.getBodySize()];
            this.getBodyBuffer().readBytes(readBuffer);
            out.write(readBuffer);
            out.flush();
        }
        catch (IOException e) {
            throw new HornetQException(110, "Error saving the message body", e);
        }
    }

    @Override
    public void setOutputStream(OutputStream out) throws HornetQException {
        this.saveToOutputStream(out);
    }

    @Override
    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws HornetQException {
        return true;
    }

    @Override
    public void discardBody() {
    }

    @Override
    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    @Override
    public void setBodyInputStream(InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
    }

    @Override
    public void setBuffer(HornetQBuffer buffer) {
        this.buffer = buffer;
        if (this.bodyBuffer != null) {
            this.bodyBuffer.setBuffer(buffer);
        }
    }

    @Override
    public BodyEncoder getBodyEncoder() throws HornetQException {
        return new DecodingContext();
    }

    private final class DecodingContext
    implements BodyEncoder {
        @Override
        public void open() {
            ClientMessageImpl.this.getBodyBuffer().readerIndex(0);
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            if (ClientMessageImpl.this.isLargeMessage()) {
                return ClientMessageImpl.this.getBodyBuffer().writerIndex();
            }
            return ClientMessageImpl.this.getBodyBuffer().writerIndex() - 17;
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws HornetQException {
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer(bufferRead);
            return this.encode(buffer, bufferRead.capacity());
        }

        @Override
        public int encode(HornetQBuffer bufferOut, int size) {
            byte[] bytes = new byte[size];
            ClientMessageImpl.this.getWholeBuffer().readBytes(bytes);
            bufferOut.writeBytes(bytes, 0, size);
            return size;
        }
    }
}

