/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant.info.drl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.ide.common.assistant.info.RuleRefactorInfo;
import org.drools.ide.common.assistant.info.drl.DRLContentTypeEnum;
import org.drools.ide.common.assistant.info.drl.RuleBasicContentInfo;
import org.drools.ide.common.assistant.info.drl.RuleDRLContentInfo;
import org.drools.ide.common.assistant.info.drl.RuleLineContentInfo;

public class DRLRuleRefactorInfo
implements RuleRefactorInfo {
    private Map<Integer, RuleBasicContentInfo> contents = new TreeMap<Integer, RuleBasicContentInfo>();

    public void addContent(DRLContentTypeEnum type, Integer offset, String content) {
        this.contents.put(offset, new RuleBasicContentInfo(offset, content, type));
    }

    public void addContent(DRLContentTypeEnum type, int offset, String content, String ruleName, List<RuleLineContentInfo> lhs, List<RuleLineContentInfo> rhs) {
        RuleDRLContentInfo contentInfo = new RuleDRLContentInfo(offset, content, type, ruleName, lhs, rhs);
        for (RuleLineContentInfo ruleLine : contentInfo.getLHSRuleLines()) {
            ruleLine.setRule(contentInfo);
        }
        for (RuleLineContentInfo ruleLine : contentInfo.getRHSRuleLines()) {
            ruleLine.setRule(contentInfo);
        }
        this.contents.put(offset, contentInfo);
    }

    public RuleBasicContentInfo getContentAt(int offset) {
        if (this.contents.containsKey(offset)) {
            return this.contents.get(offset);
        }
        int previousKey = 0;
        for (Integer key : this.contents.keySet()) {
            if (key > offset) {
                RuleBasicContentInfo info = this.contents.get(previousKey);
                if (previousKey + info.getContentLength() >= offset) {
                    if (info.getType().equals((Object)DRLContentTypeEnum.RULE)) {
                        return this.searchInsideTheRule(offset, (RuleDRLContentInfo)info);
                    }
                    return info;
                }
                return null;
            }
            previousKey = key;
        }
        RuleBasicContentInfo info = this.contents.get(previousKey);
        if (info.getType().equals((Object)DRLContentTypeEnum.RULE)) {
            return this.searchInsideTheRule(offset, (RuleDRLContentInfo)info);
        }
        return info.getContentLength() + previousKey > offset ? info : null;
    }

    private RuleBasicContentInfo searchInsideTheRule(int offset, RuleDRLContentInfo info) {
        if (offset <= info.getRuleNameLength() + info.getOffset()) {
            return null;
        }
        for (RuleLineContentInfo ruleLine : info.getLHSRuleLines()) {
            if (offset > ruleLine.getOffset() + ruleLine.getContentLength()) continue;
            return ruleLine;
        }
        for (RuleLineContentInfo ruleLine : info.getRHSRuleLines()) {
            if (offset > ruleLine.getOffset() + ruleLine.getContentLength()) continue;
            return ruleLine;
        }
        return null;
    }

    public List<RuleBasicContentInfo> getImports() {
        ArrayList<RuleBasicContentInfo> imports = new ArrayList<RuleBasicContentInfo>();
        for (Integer key : this.contents.keySet()) {
            RuleBasicContentInfo info = this.contents.get(key);
            if (!info.getType().equals((Object)DRLContentTypeEnum.IMPORT)) continue;
            imports.add(info);
        }
        return imports;
    }
}

