/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.HasConstraints;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class CompositeFieldConstraint
implements FieldConstraint,
HasConstraints {
    public static final String COMPOSITE_TYPE_OR = "||";
    public static final String COMPOSITE_TYPE_AND = "&&";
    public String compositeJunctionType = null;
    public FieldConstraint[] constraints = null;

    @Override
    public void addConstraint(FieldConstraint constraint) {
        if (this.constraints == null) {
            this.constraints = new FieldConstraint[1];
            this.constraints[0] = constraint;
        } else {
            FieldConstraint[] newList = new FieldConstraint[this.constraints.length + 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                newList[i] = this.constraints[i];
            }
            newList[this.constraints.length] = constraint;
            this.constraints = newList;
        }
    }

    @Override
    public void removeConstraint(int idx) {
        FieldConstraint constraintToRemove = this.constraints[idx];
        if (constraintToRemove instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)constraintToRemove;
            FieldConstraint parent = sfc.getParent();
            for (FieldConstraint child : this.constraints) {
                SingleFieldConstraint sfcChild;
                if (!(child instanceof SingleFieldConstraint) || (sfcChild = (SingleFieldConstraint)child).getParent() != constraintToRemove) continue;
                sfcChild.setParent(parent);
                break;
            }
        }
        FieldConstraint[] newList = new FieldConstraint[this.constraints.length - 1];
        int newIdx = 0;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (i == idx) continue;
            newList[newIdx] = this.constraints[i];
            ++newIdx;
        }
        this.constraints = newList;
    }

    @Override
    public FieldConstraint getConstraint(int index) {
        if (this.constraints == null) {
            return null;
        }
        return this.constraints[index];
    }

    @Override
    public int getNumberOfConstraints() {
        if (this.constraints == null) {
            return 0;
        }
        return this.constraints.length;
    }
}

