/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import org.drools.ide.common.client.modeldriven.testing.CollectionFieldData;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.FactAssignmentField;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;

public class FieldConverter
implements Converter {
    private final XStream xt;

    public FieldConverter(XStream xt) {
        this.xt = xt;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        context.convertAnother(source, (Converter)this.getDefaultConverter());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        String name = reader.getValue();
        reader.moveUp();
        reader.moveDown();
        if (reader.getNodeName().equals("collectionFieldList")) {
            CollectionFieldData collectionFieldData = this.createCollectionFieldData(context, name);
            reader.moveUp();
            return collectionFieldData;
        }
        if (reader.getNodeName().equals("value")) {
            CollectionFieldData collectionFieldData;
            FieldData fieldData = new FieldData();
            fieldData.setName(name);
            fieldData.setValue(reader.getValue());
            reader.moveUp();
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                String value = reader.getValue();
                fieldData.setNature(Integer.parseInt(value));
                reader.moveUp();
            }
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("collectionFieldList")) {
                    collectionFieldData = this.createCollectionFieldData(context, name);
                    reader.moveUp();
                    if (!collectionFieldData.getCollectionFieldList().isEmpty()) {
                        return collectionFieldData;
                    }
                }
            }
            if (fieldData.getValue() != null && fieldData.getValue().startsWith("=[")) {
                collectionFieldData = new CollectionFieldData();
                collectionFieldData.setName(name);
                String list = fieldData.getValue().substring(2, fieldData.getValue().length() - 1);
                if (list.contains(",")) {
                    for (String value : list.split(",")) {
                        FieldData subFieldData = new FieldData();
                        subFieldData.setName(name);
                        subFieldData.setValue(value);
                        collectionFieldData.getCollectionFieldList().add(subFieldData);
                    }
                } else {
                    FieldData subFieldData = new FieldData();
                    subFieldData.setName(name);
                    subFieldData.setValue(list);
                    collectionFieldData.getCollectionFieldList().add(subFieldData);
                }
                return collectionFieldData;
            }
            return fieldData;
        }
        if (reader.getNodeName().equals("fact")) {
            FactAssignmentField factAssignmentField = new FactAssignmentField();
            factAssignmentField.setName(name);
            factAssignmentField.setFact((Fact)context.convertAnother((Object)factAssignmentField, Fact.class));
            reader.moveUp();
            return factAssignmentField;
        }
        throw new InvalidParameterException("Unknown Field instance.");
    }

    private CollectionFieldData createCollectionFieldData(UnmarshallingContext context, String name) {
        CollectionFieldData collectionFieldData = new CollectionFieldData();
        collectionFieldData.setName(name);
        collectionFieldData.setCollectionFieldList((ArrayList)context.convertAnother((Object)collectionFieldData, ArrayList.class));
        return collectionFieldData;
    }

    public boolean canConvert(Class type) {
        return Field.class.isAssignableFrom(type);
    }

    private ReflectionConverter getDefaultConverter() {
        return new ReflectionConverter(this.xt.getMapper(), this.xt.getReflectionProvider());
    }
}

