/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;

public class GuvnorWorkspaceFilePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Control createContents(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 2);
        IResource resource = (IResource)super.getElement().getAdapter(IResource.class);
        if (resource != null) {
            this.displayGuvnorProperties(composite, resource);
        } else {
            this.indicateNotGuvnorAssociated(composite);
        }
        return composite;
    }

    private void displayGuvnorProperties(Composite composite, IResource resource) {
        try {
            GuvnorMetadataProps props = GuvnorMetadataUtils.getGuvnorMetadata(resource);
            if (props == null) {
                this.indicateNotGuvnorAssociated(composite);
            } else {
                this.addGuvnorProperties(composite, props);
            }
        }
        catch (Exception e) {
            Activator.getDefault().writeLog(4, e.getMessage(), e);
        }
    }

    private void addGuvnorProperties(Composite composite, GuvnorMetadataProps props) {
        new Label(composite, 0).setText(Messages.getString("repository.label"));
        Label l = new Label(composite, 0);
        String val = props.getRepository() != null ? props.getRepository() : "";
        l.setText(val);
        new Label(composite, 0).setText(Messages.getString("repository.path"));
        l = new Label(composite, 0);
        String fullpath = props.getFullpath() != null ? props.getFullpath().substring(val.length()) : "";
        l.setText(fullpath);
        new Label(composite, 0).setText(Messages.getString("repository.resource.version"));
        l = new Label(composite, 0);
        val = props.getVersion() != null ? props.getVersion() : "";
        l.setText(val);
        new Label(composite, 0).setText(Messages.getString("repository.resource.revision"));
        l = new Label(composite, 0);
        val = props.getVersion() != null ? props.getRevision() : "";
        l.setText(val);
    }

    private void indicateNotGuvnorAssociated(Composite composite) {
        new Label(composite, 0).setText(Messages.getString("not.guvnor.associated"));
    }
}

