/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kproject;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.CompositeKnowledgeBuilder;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.core.util.StringUtils;
import org.drools.io.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KBaseBuilder {
    private EventProcessingOption eventProcessingMode;
    private AssertBehaviorOption equalsBehaviour;

    protected KBaseBuilder() {
    }

    public static KBaseBuilder fluent() {
        return new KBaseBuilder();
    }

    public KBaseBuilder setEqualsBehavior(AssertBehaviorOption equalsBehaviour) {
        this.equalsBehaviour = equalsBehaviour;
        return this;
    }

    public KBaseBuilder setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        this.eventProcessingMode = eventProcessingMode;
        return this;
    }

    public KnowledgeBase build(Class[] kBaseQualifiers) {
        HashMap<Class, ArrayList<String>> map = new HashMap<Class, ArrayList<String>>();
        if (kBaseQualifiers != null && kBaseQualifiers.length > 0) {
            for (Class kBaseQualifier : kBaseQualifiers) {
                ArrayList<String> list = new ArrayList<String>();
                KBaseBuilder.buildResourcesList(kBaseQualifier, kBaseQualifier.getName(), list);
                map.put(kBaseQualifier, list);
            }
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        for (Map.Entry entry : map.entrySet()) {
            Class cls = (Class)entry.getKey();
            List files = (List)entry.getValue();
            if (files.isEmpty()) continue;
            for (String file : files) {
                if (!file.endsWith(".drl")) continue;
                ckbuilder.add(ResourceFactory.newUrlResource((URL)cls.getResource("/" + file.trim())), ResourceType.DRL);
            }
        }
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Unable to compile " + kBaseQualifiers[0].getName() + ":\n" + kbuilder.getErrors());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)this.eventProcessingMode);
        kconf.setOption((KnowledgeBaseOption)this.equalsBehaviour);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void buildResourcesList(Class cls, String kBaseQName, List<String> list) {
        String fileStr;
        block9: {
            fileStr = null;
            InputStream is = null;
            try {
                try {
                    is = cls.getResourceAsStream("/" + kBaseQName + ".files.dat");
                    fileStr = StringUtils.toString((InputStream)is);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to fine files for KnowledgeBase " + kBaseQName);
                }
                Object var7_5 = null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to fine files for KnowledgeBase " + kBaseQName);
                }
            }
            try {}
            catch (IOException e) {
                throw new RuntimeException("Unable to fine files for KnowledgeBase " + kBaseQName);
            }
            is.close();
        }
        if (StringUtils.isEmpty((CharSequence)fileStr)) return;
        String[] arr$ = fileStr.split(",");
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String entry = arr$[i$];
            if (!StringUtils.isEmpty((CharSequence)entry)) {
                list.add(entry.trim());
            }
            ++i$;
        }
    }
}

