/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@SequenceGenerator(name="processInstanceLogIdSeq", sequenceName="PROC_INST_LOG_ID_SEQ", allocationSize=1)
public class ProcessInstanceLog
implements Serializable {
    private static final long serialVersionUID = 510L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="processInstanceLogIdSeq")
    private long id;
    private long processInstanceId;
    private String processId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="start_date")
    private Date start;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="end_date")
    private Date end;
    @Column(nullable=true)
    private int status;
    @Column(nullable=true)
    private long parentProcessInstanceId;
    @Column(nullable=true)
    private String outcome;

    ProcessInstanceLog() {
    }

    public ProcessInstanceLog(long processInstanceId, String processId) {
        this.setProcessInstanceId(processInstanceId);
        this.setProcessId(processId);
        this.setStart(new Date());
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    private void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String toString() {
        return "Process '" + this.processId + "' [" + this.processInstanceId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (int)this.id;
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (int)this.processInstanceId;
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (int)this.parentProcessInstanceId;
        result = 31 * result + this.status;
        result = 31 * result + (this.outcome == null ? 0 : this.outcome.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceLog other = (ProcessInstanceLog)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        if (this.parentProcessInstanceId != other.parentProcessInstanceId) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.outcome == null ? other.outcome != null : !this.outcome.equals(other.outcome));
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String errorCode) {
        this.outcome = errorCode;
    }
}

