/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.ResponseBody;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MultiStatus
extends ElementEditor {
    protected static final String[] childNames = new String[]{"response", "responsedescription"};

    public MultiStatus(Element root) throws MalformedElementException {
        super(root, "multistatus");
    }

    public ResponseBody addResponse() {
        Element response = MultiStatus.addChild(this.root, "response", childNames, true);
        try {
            return new ResponseBody(response);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public static MultiStatus create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = MultiStatus.create(document, "multistatus");
        try {
            return new MultiStatus(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
            return null;
        }
    }

    public String getResponseDescription() throws MalformedElementException {
        return MultiStatus.getChildText(this.root, "responsedescription", false);
    }

    public Enumeration getResponses() throws MalformedElementException {
        Element firstResponse = MultiStatus.getFirstChild(this.root, "response");
        MultiStatus.ensureNotNull(Policy.bind("ensure.missingResponseElmt"), firstResponse);
        Enumeration e = new Enumeration(firstResponse){
            Element currentResponse;
            {
                this.currentResponse = element;
            }

            public boolean hasMoreElements() {
                return this.currentResponse != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                ResponseBody responseBody = null;
                try {
                    responseBody = new ResponseBody(this.currentResponse);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentResponse = MultiStatus.getTwin(this.currentResponse, true);
                return responseBody;
            }
        };
        return e;
    }

    public void setResponseDescription(String value) {
        if (value == null) {
            Element child = MultiStatus.getLastChild(this.root, "responsedescription");
            if (child != null) {
                this.root.removeChild(child);
            }
        } else {
            MultiStatus.setChild(this.root, "responsedescription", value, childNames, false);
        }
    }
}

