/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.dom.QualifiedNameImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Prop
extends ElementEditor {
    public Prop(Element root) throws MalformedElementException {
        super(root, "prop");
    }

    public void addProperty(Element element) throws MalformedElementException {
        Assert.isNotNull(element);
        Prop.extractNode(this.root, element);
    }

    public void addPropertyName(QualifiedName name) {
        Assert.isNotNull(name);
        String nsName = name.getQualifier();
        Assert.isTrue(!"".equals(nsName));
        String localName = name.getLocalName();
        Assert.isNotNull(localName);
        Assert.isTrue(!localName.equals(""));
        Document document = this.root.getOwnerDocument();
        Element element = document.createElement(localName);
        Prop.declareNS(element, null, nsName);
        this.root.appendChild(element);
    }

    public Enumeration getProperties() throws MalformedElementException {
        Element firstChild;
        Element firstElement = firstChild = Prop.getChildElement(this.root, true);
        Enumeration e = new Enumeration(firstElement){
            Node currentElement;
            {
                this.currentElement = node;
            }

            public boolean hasMoreElements() {
                return this.currentElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                Node nextElement = this.currentElement;
                this.currentElement = Prop.getNextSibling((Element)this.currentElement);
                return nextElement;
            }
        };
        return e;
    }

    public Enumeration getPropertyNames() throws MalformedElementException {
        Element firstChild;
        Element firstElement = firstChild = Prop.getChildElement(this.root, true);
        Enumeration e = new Enumeration(firstElement){
            Node currentElement;
            {
                this.currentElement = node;
            }

            public boolean hasMoreElements() {
                return this.currentElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String nsName = null;
                try {
                    nsName = Prop.getNSName((Element)this.currentElement);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                String localName = Prop.getNSLocalName((Element)this.currentElement);
                QualifiedNameImpl name = new QualifiedNameImpl(nsName, localName);
                this.currentElement = Prop.getNextSibling((Element)this.currentElement);
                return name;
            }
        };
        return e;
    }
}

