/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.util.Hashtable;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;

public class AuthenticateChallenge {
    private String challenge;
    private Parser parser;
    private String authScheme;
    private Hashtable authParams;

    public AuthenticateChallenge(String challenge) throws ParserException {
        this.challenge = challenge;
        this.parser = new Parser(challenge);
        this.parse();
    }

    public String get(String param) {
        return (String)this.authParams.get(param);
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getRealm() {
        return this.get("realm");
    }

    private void parse() throws ParserException {
        this.authParams = new Hashtable(5);
        this.authScheme = this.parser.nextToken();
        this.parser.skipWhiteSpace();
        boolean done = false;
        while (!done) {
            String param = this.parser.nextToken();
            this.parser.match('=');
            String value = null;
            this.parser.checkPosition();
            value = this.challenge.charAt(this.parser.pos) == '\"' ? this.parser.nextQuotedString() : this.parser.nextToken();
            this.authParams.put(param, value);
            this.parser.skipWhiteSpace();
            boolean bl = done = this.parser.pos == this.challenge.length();
            if (done) continue;
            this.parser.match(',');
            this.parser.skipWhiteSpace();
        }
        if (this.getRealm() == null) {
            throw new ParserException(Policy.bind("exception.missingRealm"));
        }
    }
}

