/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final char[] ioBuffer = new char[4096];
    static final /* synthetic */ boolean $assertionsDisabled;

    public CharTokenizer(Reader input) {
        super(input);
    }

    protected abstract boolean isTokenChar(char var1);

    protected char normalize(char c) {
        return c;
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        reusableToken.clear();
        int length = 0;
        int start = this.bufferIndex;
        char[] buffer = reusableToken.termBuffer();
        while (true) {
            char c;
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                this.dataLen = this.input.read(this.ioBuffer);
                if (this.dataLen == -1) {
                    if (length <= 0) {
                        return null;
                    }
                    break;
                }
                this.bufferIndex = 0;
            }
            if (this.isTokenChar(c = this.ioBuffer[this.bufferIndex++])) {
                if (length == 0) {
                    start = this.offset + this.bufferIndex - 1;
                } else if (length == buffer.length) {
                    buffer = reusableToken.resizeTermBuffer(1 + length);
                }
                buffer[length++] = this.normalize(c);
                if (length != 255) continue;
                break;
            }
            if (length > 0) break;
        }
        reusableToken.setTermLength(length);
        reusableToken.setStartOffset(start);
        reusableToken.setEndOffset(start + length);
        return reusableToken;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
    }

    static {
        $assertionsDisabled = !CharTokenizer.class.desiredAssertionStatus();
    }
}

