/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class DroolsLineBreakpointAdapter
implements IToggleBreakpointsTarget {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        block5: {
            if (part instanceof IEditorPart && selection instanceof ITextSelection) {
                DRLInfo drlInfo;
                int lineNumber;
                block6: {
                    IEditorPart editor = (IEditorPart)part;
                    IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
                    ITextSelection textSelection = (ITextSelection)selection;
                    lineNumber = textSelection.getStartLine();
                    drlInfo = DroolsEclipsePlugin.getDefault().parseResource(resource, false);
                    if (drlInfo == null) break block5;
                    DRLInfo.RuleInfo ruleInfo = drlInfo.getRuleInfo(lineNumber);
                    if (ruleInfo == null || ruleInfo.getConsequenceDrlLineNumber() > lineNumber) break block6;
                    return true;
                }
                try {
                    DRLInfo.FunctionInfo functionInfo = drlInfo.getFunctionInfo(lineNumber);
                    if (functionInfo != null && functionInfo.getDrlLineNumber() <= lineNumber) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    DroolsEclipsePlugin.log(t);
                }
            }
        }
        return false;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.drools.eclipse.debug");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource()) && breakpoint.getMarker().getType().equals("org.drools.eclipse.droolsBreakpointMarker") && ((DroolsLineBreakpoint)breakpoint).getDRLLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            DroolsLineBreakpoint lineBreakpoint = new DroolsLineBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

