/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.model;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ModelElement;
import org.drools.spi.Constraint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class GraphicalVertex
extends ModelElement {
    private static final String VERTEX_NAME = "BaseVertex ";
    private static final String WIDTH = "Width";
    private static final String HEIGHT = "Height";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"BaseVertex .xPos", "X"), new TextPropertyDescriptor((Object)"BaseVertex .yPos", "Y"), new TextPropertyDescriptor((Object)"BaseVertex .Width", "Width"), new TextPropertyDescriptor((Object)"BaseVertex .Height", "Height")};
    private static final String HEIGHT_PROP = "BaseVertex .Height";
    private static final String WIDTH_PROP = "BaseVertex .Width";
    public static final String LOCATION_PROP = "BaseVertex .Location";
    public static final String SIZE_PROP = "BaseVertex .Size";
    public static final String SOURCE_CONNECTIONS_PROP = "BaseVertex .SourceConn";
    public static final String TARGET_CONNECTIONS_PROP = "BaseVertex .TargetConn";
    private static final String XPOS_PROP = "BaseVertex .xPos";
    private static final String YPOS_PROP = "BaseVertex .yPos";
    private Point location = new Point(0, 0);
    private static final Dimension size = new Dimension(16, 16);
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();

    public abstract String getHtml();

    public abstract Color getFillColor();

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public Point getLocation() {
        return this.location.getCopy();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propertyId) {
        if (XPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.x);
        }
        if (YPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.y);
        }
        if (HEIGHT_PROP.equals(propertyId)) {
            return Integer.toString(GraphicalVertex.size.height);
        }
        if (WIDTH_PROP.equals(propertyId)) {
            return Integer.toString(GraphicalVertex.size.width);
        }
        return null;
    }

    public Dimension getSize() {
        return size.getCopy();
    }

    public List getSourceConnections() {
        return new ArrayList(this.sourceConnections);
    }

    public List getTargetConnections() {
        return new ArrayList(this.targetConnections);
    }

    public void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    public void setPropertyValue(Object propertyId, Object value) {
        if (XPOS_PROP.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.location.y));
        } else if (YPOS_PROP.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.location.x, y));
        } else if (HEIGHT_PROP.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(GraphicalVertex.size.width, height));
        } else if (WIDTH_PROP.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, GraphicalVertex.size.height));
        }
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, size);
        }
    }

    public String toString() {
        return VERTEX_NAME + this.hashCode();
    }

    public Color getDrawColor() {
        return ColorConstants.black;
    }

    public static String dumpConstraints(Constraint[] constraints) {
        if (constraints == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = constraints.length;
        while (i < length) {
            buffer.append(String.valueOf(constraints[i].toString()) + "<br>");
            ++i;
        }
        return buffer.toString();
    }
}

